/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.utils;

import com.zoho.crm.api.record.Record;
import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.zoho.ZohoUtils;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public final class ZohoMetisUserUtils {
    private ZohoMetisUserUtils() {
    }

    public static MetisUser checkZohoFieldsAndPopulateMetisUser(Record zohoRecord) throws BadContentException {
        MetisUser metisUser = new MetisUser();
        metisUser.setUserId(Long.toString(zohoRecord.getId()));
        metisUser.setFirstName(ZohoUtils.stringFieldSupplier((Object)zohoRecord.getKeyValue("First_Name")));
        metisUser.setLastName(ZohoUtils.stringFieldSupplier((Object)zohoRecord.getKeyValue("Last_Name")));
        metisUser.setEmail(ZohoUtils.stringFieldSupplier((Object)zohoRecord.getKeyValue("Email")));
        metisUser.setCreatedDate(zohoRecord.getCreatedTime() == null ? null : Date.from(zohoRecord.getCreatedTime().toInstant()));
        metisUser.setUpdatedDate(zohoRecord.getModifiedTime() == null ? null : Date.from(zohoRecord.getModifiedTime().toInstant()));
        metisUser.setCountry(ZohoUtils.stringFieldSupplier((Object)zohoRecord.getKeyValue("Country")));
        List participationLevel = (List)zohoRecord.getKeyValue("Participation_level");
        if (!CollectionUtils.isEmpty((Collection)participationLevel) && participationLevel.contains("Network Association Member")) {
            metisUser.setNetworkMember(true);
        }
        if (zohoRecord.getKeyValue("Metis_user") != null) {
            metisUser.setMetisUserFlag((Boolean)zohoRecord.getKeyValue("Metis_user"));
        }
        metisUser.setAccountRole(AccountRole.getAccountRoleFromEnumName(ZohoUtils.stringFieldSupplier((Object)zohoRecord.getKeyValue("Pick_List_3"))));
        if (metisUser.getAccountRole() == AccountRole.METIS_ADMIN) {
            throw new BadContentException("Account Role in Zoho is not valid");
        }
        Record accountName = (Record)zohoRecord.getKeyValue("Account_Name");
        metisUser.setOrganizationId(Long.toString(accountName.getId()));
        metisUser.setOrganizationName(ZohoUtils.stringFieldSupplier((Object)accountName.getKeyValue("name")));
        return metisUser;
    }
}

