/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.utils;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import eu.europeana.metis.authentication.user.MetisZohoOAuthToken;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class MetisZohoOAuthPSQLHandler
implements TokenStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetisZohoOAuthPSQLHandler.class);
    private static final String USER_IDENTIFIER_STRING = "userIdentifier";
    private final SessionFactory sessionFactory;
    private final String clientId;
    private final String clientSecret;

    public MetisZohoOAuthPSQLHandler(SessionFactory sessionFactory, @Nullable String userEmailId, @Nullable String refreshToken, String clientId, String clientSecret) {
        this.sessionFactory = sessionFactory;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.initializeWithRefreshToken(userEmailId, refreshToken);
    }

    private void initializeWithRefreshToken(@Nullable String userEmailId, @Nullable String refreshToken) {
        if (StringUtils.isNotBlank((CharSequence)userEmailId) && StringUtils.isNotBlank((CharSequence)refreshToken)) {
            MetisZohoOAuthToken metisZohoOAuthToken = new MetisZohoOAuthToken(userEmailId, "", refreshToken, 0L);
            try (Session dbSession = this.sessionFactory.openSession();){
                SonarqubeNullcheckAvoidanceUtils.performAction((Object)dbSession, session -> {
                    Transaction tx = session.beginTransaction();
                    session.saveOrUpdate((Object)metisZohoOAuthToken);
                    String potentialErrorMessage = "Exception while saving zoho oauth user tokens";
                    MetisZohoOAuthPSQLHandler.commitTransaction(tx, potentialErrorMessage);
                });
            }
        }
    }

    public Token getToken(UserSignature userSignature, Token token) {
        MetisZohoOAuthToken metisZohoOAuthToken;
        try (Session dbSession = this.sessionFactory.openSession();){
            metisZohoOAuthToken = (MetisZohoOAuthToken)SonarqubeNullcheckAvoidanceUtils.performThrowingFunction((Object)dbSession, session -> {
                Transaction tx = session.beginTransaction();
                Query query = session.createQuery(String.format("FROM MetisZohoOAuthToken WHERE %s = :%s", USER_IDENTIFIER_STRING, USER_IDENTIFIER_STRING));
                query.setParameter(USER_IDENTIFIER_STRING, (Object)userSignature.getEmail());
                if (query.list().isEmpty()) {
                    return null;
                }
                MetisZohoOAuthToken foundToken = (MetisZohoOAuthToken)query.list().get(0);
                String potentialErrorMessage = "Exception while retrieving zoho oauth user tokens";
                MetisZohoOAuthPSQLHandler.commitTransaction(tx, potentialErrorMessage);
                return foundToken;
            });
        }
        return metisZohoOAuthToken == null ? null : metisZohoOAuthToken.convertToZohoOAuthToken(this.clientId, this.clientSecret);
    }

    public void saveToken(UserSignature userSignature, Token token) {
        OAuthToken oAuthToken = (OAuthToken)token;
        MetisZohoOAuthToken metisZohoOAuthToken = new MetisZohoOAuthToken(userSignature.getEmail(), oAuthToken.getAccessToken(), oAuthToken.getRefreshToken(), Long.valueOf(oAuthToken.getExpiresIn()));
        try (Session dbSession = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)dbSession, session -> {
                Transaction tx = session.beginTransaction();
                session.saveOrUpdate((Object)metisZohoOAuthToken);
                String potentialErrorMessage = "Exception while saving zoho oauth user tokens";
                MetisZohoOAuthPSQLHandler.commitTransaction(tx, potentialErrorMessage);
            });
        }
    }

    public void deleteToken(Token token) {
        String userIdentifier = ((OAuthToken)token).getUserMail();
        try (Session dbSession = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)dbSession, session -> {
                Transaction tx = session.beginTransaction();
                Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisZohoOAuthToken WHERE %s = :%s", USER_IDENTIFIER_STRING, USER_IDENTIFIER_STRING));
                deleteQuery.setParameter(USER_IDENTIFIER_STRING, (Object)userIdentifier);
                int i = deleteQuery.executeUpdate();
                String potentialErrorMessage = "Exception while deleting zoho oauth user tokens";
                MetisZohoOAuthPSQLHandler.commitTransaction(tx, potentialErrorMessage);
                LOGGER.info("Removed {} Metis Zoho OAuth tokens with user identifier: {}", (Object)i, (Object)userIdentifier);
            });
        }
    }

    public List<Token> getTokens() {
        LOGGER.warn("Returning null, this method is not supported");
        return Collections.emptyList();
    }

    public void deleteTokens() {
        LOGGER.warn("Did nothing, this method is not supported");
    }

    private static void commitTransaction(Transaction tx, String potentialErrorMessage) {
        try {
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Transaction commit failed with message '{}', rolling back..", (Object)potentialErrorMessage);
            throw new TransactionException(String.format("Transaction commit failed with message '%s'", potentialErrorMessage), (Throwable)e);
        }
    }

    public void close() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
        }
    }
}

