/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.utils;

import com.zoho.crm.library.crud.ZCRMRecord;
import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.zoho.ZohoUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.util.CollectionUtils;

public final class ZohoMetisUserUtils {
    private ZohoMetisUserUtils() {
    }

    public static MetisUser checkZohoFieldsAndPopulateMetisUser(ZCRMRecord zcrmRecord) throws BadContentException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.US);
        HashMap zohoFields = zcrmRecord.getData();
        MetisUser metisUser = new MetisUser();
        metisUser.setUserId(Long.toString(zcrmRecord.getEntityId()));
        metisUser.setFirstName(ZohoUtils.stringFieldSupplier(zohoFields.get("First_Name")));
        metisUser.setLastName(ZohoUtils.stringFieldSupplier(zohoFields.get("Last_Name")));
        metisUser.setEmail(ZohoUtils.stringFieldSupplier(zohoFields.get("Email")));
        try {
            metisUser.setCreatedDate(zcrmRecord.getCreatedTime() == null ? null : dateFormat.parse(zcrmRecord.getCreatedTime()));
            metisUser.setUpdatedDate(zcrmRecord.getModifiedTime() == null ? null : dateFormat.parse(zcrmRecord.getModifiedTime()));
        }
        catch (ParseException ex) {
            throw new BadContentException("Created or updated date could not be parsed.", (Throwable)ex);
        }
        metisUser.setCountry(ZohoUtils.stringFieldSupplier(zohoFields.get("Country")));
        List participationLevel = (List)zohoFields.get("Participation_level");
        if (!CollectionUtils.isEmpty((Collection)participationLevel) && participationLevel.contains("Network Association Member")) {
            metisUser.setNetworkMember(true);
        }
        if (zohoFields.get("Metis_user") != null) {
            metisUser.setMetisUserFlag((Boolean)zohoFields.get("Metis_user"));
        }
        metisUser.setAccountRole(AccountRole.getAccountRoleFromEnumName(ZohoUtils.stringFieldSupplier(zohoFields.get("Pick_List_3"))));
        if (metisUser.getAccountRole() == AccountRole.METIS_ADMIN) {
            throw new BadContentException("Account Role in Zoho is not valid");
        }
        ZCRMRecord accountName = (ZCRMRecord)zohoFields.get("Account_Name");
        metisUser.setOrganizationId(Long.toString(accountName.getEntityId()));
        metisUser.setOrganizationName(accountName.getLookupLabel());
        return metisUser;
    }
}

