/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.utils;

import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.contract.ZohoOAuthTokens;
import eu.europeana.metis.authentication.user.MetisZohoOAuthToken;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetisZohoOAuthPSQLHandler
implements ZohoPersistenceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetisZohoOAuthPSQLHandler.class);
    private static final String USER_IDENTIFIER_STRING = "userIdentifier";
    private static final SessionFactory sessionFactory;

    public void saveOAuthData(ZohoOAuthTokens zohoOAuthTokens) throws Exception {
        MetisZohoOAuthToken metisZohoOAuthToken = new MetisZohoOAuthToken(zohoOAuthTokens.getUserMailId(), zohoOAuthTokens.getAccessToken(), zohoOAuthTokens.getRefreshToken(), zohoOAuthTokens.getExpiryTime());
        try (Session session = sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            session.saveOrUpdate((Object)metisZohoOAuthToken);
            String potentialErrorMessage = "Exception while saving zoho oauth user tokens";
            this.commitTransaction(tx, potentialErrorMessage);
        }
    }

    public ZohoOAuthTokens getOAuthTokens(String userIdentifier) throws Exception {
        MetisZohoOAuthToken metisZohoOAuthToken;
        try (Session session = sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery(String.format("FROM MetisZohoOAuthToken WHERE %s = :%s", USER_IDENTIFIER_STRING, USER_IDENTIFIER_STRING));
            query.setParameter(USER_IDENTIFIER_STRING, (Object)userIdentifier);
            if (query.list().isEmpty()) {
                throw new ZohoOAuthException("Given User not found in persistence.");
            }
            metisZohoOAuthToken = (MetisZohoOAuthToken)query.list().get(0);
            String potentialErrorMessage = "Exception while retrieving zoho oauth user tokens";
            this.commitTransaction(tx, potentialErrorMessage);
        }
        return metisZohoOAuthToken == null ? null : metisZohoOAuthToken.convertToZohoOAuthTokens();
    }

    public void deleteOAuthTokens(String userIdentifier) {
        try (Session session = sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisZohoOAuthToken WHERE %s = :%s", USER_IDENTIFIER_STRING, USER_IDENTIFIER_STRING));
            deleteQuery.setParameter(USER_IDENTIFIER_STRING, (Object)userIdentifier);
            int i = deleteQuery.executeUpdate();
            String potentialErrorMessage = "Exception while deleting zoho oauth user tokens";
            this.commitTransaction(tx, potentialErrorMessage);
            LOGGER.info("Removed {} Metis Zoho OAuth tokens with user identifier: {}", (Object)i, (Object)userIdentifier);
        }
    }

    private void commitTransaction(Transaction tx, String potentialErrorMessage) {
        try {
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Transaction commit failed with message '{}', rolling back..", (Object)potentialErrorMessage);
            throw new TransactionException(String.format("Transaction commit failed with message '%s'", potentialErrorMessage), (Throwable)e);
        }
    }

    public static void close() {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            sessionFactory.close();
        }
    }

    static {
        Configuration configuration = new Configuration();
        configuration.addAnnotatedClass(MetisZohoOAuthToken.class);
        configuration.configure();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
    }
}

