/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.exception.BadContentException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="metis_users")
public class MetisUser {
    @Column(name="user_id")
    private String userId;
    @Id
    @Column(name="email")
    private String email;
    @Column(name="first_name")
    private String firstName;
    @Column(name="last_name")
    private String lastName;
    @Column(name="password")
    @JsonIgnore
    private String password;
    @Column(name="organization_id")
    private String organizationId;
    @Column(name="organization_name")
    private String organizationName;
    @Column(name="account_role")
    @Enumerated(value=EnumType.STRING)
    private AccountRole accountRole;
    @Column(name="country")
    private String country;
    @Column(name="network_member")
    private boolean networkMember;
    @Column(name="metis_user")
    private boolean metisUserFlag;
    @Column(name="created_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @Column(name="updated_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedDate;
    @OneToOne
    @JoinColumn(name="email")
    private MetisUserAccessToken metisUserAccessToken;

    public MetisUser() {
    }

    public MetisUser(JsonNode jsonNode) throws ParseException, BadContentException {
        this.parseJsonNodeZohoUserToMetisUser(jsonNode);
    }

    private void parseJsonNodeZohoUserToMetisUser(JsonNode jsonNode) throws BadContentException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        Iterator elements = jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode next = (JsonNode)elements.next();
            JsonNode val = next.get("val");
            JsonNode content = next.get("content");
            switch (val.textValue()) {
                case "CONTACTID": {
                    this.userId = content.textValue();
                    break;
                }
                case "First Name": {
                    this.firstName = content.textValue();
                    break;
                }
                case "Last Name": {
                    this.lastName = content.textValue();
                    break;
                }
                case "Email": {
                    this.email = content.textValue();
                    break;
                }
                case "Created Time": {
                    this.createdDate = dateFormat.parse(content.textValue());
                    break;
                }
                case "Modified Time": {
                    this.updatedDate = dateFormat.parse(content.textValue());
                    break;
                }
                case "Country": {
                    this.country = content.textValue();
                    break;
                }
                case "Participation level": {
                    if (!content.textValue().contains("Network Association Member")) break;
                    this.networkMember = true;
                    break;
                }
                case "Metis user": {
                    this.metisUserFlag = Boolean.parseBoolean(content.textValue());
                    break;
                }
                case "Account Role": {
                    this.accountRole = AccountRole.getAccountRoleFromEnumName(content.textValue());
                    if (this.accountRole != AccountRole.METIS_ADMIN) break;
                    throw new BadContentException("Account Role in Zoho is not valid");
                }
                case "Account Name": {
                    this.organizationName = content.textValue();
                    break;
                }
            }
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public AccountRole getAccountRole() {
        return this.accountRole;
    }

    public void setAccountRole(AccountRole accountRole) {
        this.accountRole = accountRole;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean isNetworkMember() {
        return this.networkMember;
    }

    public void setNetworkMember(boolean networkMember) {
        this.networkMember = networkMember;
    }

    public boolean isMetisUserFlag() {
        return this.metisUserFlag;
    }

    public void setMetisUserFlag(boolean metisUserFlag) {
        this.metisUserFlag = metisUserFlag;
    }

    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate == null ? null : new Date(createdDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public MetisUserAccessToken getMetisUserAccessToken() {
        return this.metisUserAccessToken;
    }

    public void setMetisUserAccessToken(MetisUserAccessToken metisUserAccessToken) {
        this.metisUserAccessToken = metisUserAccessToken;
    }
}

