/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.metrics;

import eu.europeana.keycloak.repo.CustomClientRepository;
import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;

@Provider
public class UserCountProvider
implements RealmResourceProvider {
    private final KeycloakSession session;

    public UserCountProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public String get() {
        int internalKeys = this.countKeysByRoleAndAttribute("shared_owner", "scope", "internal");
        return this.toJson(this.countUsers(this.session.getContext().getRealm()), this.countKeysByRole("shared_owner"), this.countKeysByRole("client_owner"), internalKeys);
    }

    private int countKeysByRole(String roleName) {
        EntityManager entityManager = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        CustomClientRepository clientRepo = new CustomClientRepository(entityManager);
        Long clientCount = clientRepo.findKeyByRoleName(roleName);
        return clientCount.intValue();
    }

    private int countKeysByRoleAndAttribute(String roleName, String attributeName, String attributeValue) {
        EntityManager entityManager = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        CustomClientRepository clientRepo = new CustomClientRepository(entityManager);
        return clientRepo.findKeyByRoleNameAndAttributePair(roleName, attributeName, attributeValue).intValue();
    }

    private int countUsers(RealmModel realm) {
        return this.session.users().getUsersCount(realm);
    }

    public void close() {
    }

    private String toJson(int nrOfUsers, int nrOfProjectkeys, int nrOfPrivatekeys, int internalkeys) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "OverallTotal");
        obj.add("created", Instant.now().toString());
        obj.add("NumberOfUsers", nrOfUsers);
        obj.add("RegisteredClients", Json.createObjectBuilder().add("Personal", nrOfPrivatekeys).add("Project", nrOfProjectkeys - internalkeys).add("Internal", internalkeys));
        return obj.build().toString();
    }
}

