/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.metrics;

import eu.europeana.keycloak.metrics.CustomClientRepository;
import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;

@Provider
public class UserCountProvider
implements RealmResourceProvider {
    public static final String CLIENT_OWNER = "client_owner";
    public static final String SHARED_OWNER = "shared_owner";
    private final KeycloakSession session;

    public UserCountProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public String get() {
        return this.toJson(this.countUsers(this.session.getContext().getRealm()), this.countKeysByRole(SHARED_OWNER), this.countKeysByRole(CLIENT_OWNER));
    }

    private int countKeysByRole(String roleName) {
        EntityManager entityManager = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        CustomClientRepository clientRepo = new CustomClientRepository(entityManager);
        Long clientCount = clientRepo.findKeyByRoleName(roleName);
        return clientCount.intValue();
    }

    private int countUsers(RealmModel realm) {
        return this.session.users().getUsersCount(realm);
    }

    public void close() {
    }

    private String toJson(int nrOfUsers, int nrOfProjectkeys, int nrOfPrivatekeys) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "OverallTotal");
        obj.add("created", Instant.now().toString());
        obj.add("NumberOfUsers", nrOfUsers);
        obj.add("NumberOfProjectClients", nrOfProjectkeys);
        obj.add("NumberOfPersonalClients", nrOfPrivatekeys);
        return obj.build().toString();
    }
}

