/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.metrics;

import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;

@Provider
public class UserCountProvider
implements RealmResourceProvider {
    private KeycloakSession session;

    public UserCountProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @Path(value="")
    @GET
    @Produces(value={"text/plain; charset=utf-8"})
    public String get() {
        return this.toJson(this.countUsers(this.session.getContext().getRealm()));
    }

    private int countUsers(RealmModel realm) {
        return this.session.users().getUsersCount(realm);
    }

    public void close() {
    }

    private String toJson(int nrOfUsers) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "OverallTotal");
        obj.add("created", Instant.now().toString());
        obj.add("NumberOfUsers", String.valueOf(nrOfUsers));
        return obj.build().toString();
    }
}

