/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.metrics;

import java.time.Instant;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;

public class UserCountProvider
implements RealmResourceProvider {
    private KeycloakSession session;

    public UserCountProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @GET
    @Produces(value={"text/plain; charset=utf-8"})
    public String get() {
        return this.toJson(this.countUsers(this.session.getContext().getRealm()));
    }

    private int countUsers(RealmModel realm) {
        return this.session.users().getUsersCount(realm);
    }

    public void close() {
    }

    private String toJson(int nrOfUsers) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("type", "OverallTotal");
        obj.add("created", Instant.now().toString());
        obj.add("NumberOfUsers", String.valueOf(nrOfUsers));
        return obj.build().toString();
    }
}

