/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.timer;

import eu.europeana.keycloak.timer.AbstractCustomScheduledTask;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;

public class FixedRateTaskScheduler {
    private static final Logger LOG = Logger.getLogger(FixedRateTaskScheduler.class);
    public static final int MINUTES_IN_HOUR = 60;
    public static final long MILLISECONDS_IN_A_MINUTE = 6000L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AbstractCustomScheduledTask task;
    private final int intervalMinutes;

    public FixedRateTaskScheduler(AbstractCustomScheduledTask task, int intervalMinutes) {
        this.task = task;
        this.intervalMinutes = intervalMinutes;
    }

    public void scheduleTask(KeycloakSessionFactory keycloakSessionFactory) {
        LOG.info((Object)("Scheduling the task '" + this.task.getTaskName() + "' with interval " + this.intervalMinutes));
        this.scheduler.scheduleAtFixedRate((Runnable)new ClusterAwareScheduledTaskRunner(keycloakSessionFactory, (ScheduledTask)this.task, (long)this.intervalMinutes * 6000L), this.calculateInitialDelay(this.intervalMinutes), this.intervalMinutes, TimeUnit.MINUTES);
    }

    public int calculateInitialDelay(int intervalMinutes) {
        if (intervalMinutes <= 0) {
            return 0;
        }
        if (intervalMinutes > 60) {
            intervalMinutes %= 60;
        }
        int currentMinute = this.getLocalTime().getMinute();
        int minutesSinceLastInterval = currentMinute % intervalMinutes;
        int initialDelay = intervalMinutes - minutesSinceLastInterval;
        LOG.info((Object)("CurrentMinute- " + currentMinute + ", MinutesSinceLastInterval- " + minutesSinceLastInterval + ", InitialDelay- " + initialDelay));
        return initialDelay;
    }

    public LocalDateTime getLocalTime() {
        return LocalDateTime.now();
    }
}

