/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.timer;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.timer.ScheduledTask;

public abstract class AbstractCustomScheduledTask
implements ScheduledTask {
    public static final String WORK_CACHE = "work";
    public static final long LOCK_DURATION = 60000L;
    private static final Logger LOG = Logger.getLogger(AbstractCustomScheduledTask.class);

    public abstract String getTaskName();

    public void run(KeycloakSession session) {
        LOG.info((Object)("Acquiring the lock to execute the task " + this.getTaskName()));
        if (this.acquireLock(session)) {
            this.process(session);
        } else {
            LOG.info((Object)"Unable to acquire lock for clearing cache , skipping the execution !!");
        }
    }

    public abstract void process(KeycloakSession var1);

    public boolean acquireLock(KeycloakSession session) {
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache workCache = provider.getCache(WORK_CACHE);
        if (workCache != null) {
            long now = System.currentTimeMillis();
            long timeWhenLockExpires = now + 60000L;
            Long previousExpiry = (Long)workCache.getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS).putIfAbsent((Object)this.getTaskName(), (Object)timeWhenLockExpires);
            if (previousExpiry == null) {
                LOG.info((Object)("Acquired the Lock with expiry on " + timeWhenLockExpires));
                return true;
            }
            if (previousExpiry < now && workCache.getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS).replace((Object)this.getTaskName(), (Object)previousExpiry, (Object)timeWhenLockExpires)) {
                LOG.info((Object)("Took over the expired Lock and new expiry is " + timeWhenLockExpires));
                return true;
            }
        }
        LOG.error((Object)"workCache not present !!");
        return false;
    }
}

