/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.repo;

import jakarta.persistence.EntityManager;
import java.util.List;

public class CustomClientRepository {
    private final EntityManager em;

    public CustomClientRepository(EntityManager em) {
        this.em = em;
    }

    public Long findKeyByRoleName(String roleName) {
        String query = "SELECT count(c.id) FROM ClientEntity c ,RoleEntity kr where kr.clientId = c.id and kr.name = :roleNameVal";
        return (Long)this.em.createQuery(query, Long.class).setParameter("roleNameVal", (Object)roleName).getSingleResult();
    }

    public Long findKeyByRoleNameAndAttributePair(String roleName, String attributeName, String attributeValue) {
        String query = "SELECT count(c.id) FROM  ClientEntity c , RoleEntity kr, RoleAttributeEntity rae where kr.clientId = c.id and kr.name =:roleNameVal and rae.role.name = kr.name and rae.role.id = kr.id and rae.name = :name and rae.value= :value";
        return (Long)this.em.createQuery(query, Long.class).setParameter("roleNameVal", (Object)roleName).setParameter("name", (Object)attributeName).setParameter("value", (Object)attributeValue).getSingleResult();
    }

    public List<String> getInternalKeys() {
        String query = "SELECT c.clientId FROM  ClientEntity c , RoleEntity kr, RoleAttributeEntity rae where kr.clientId = c.id and kr.name =:roleNameVal and rae.role.name = kr.name and rae.role.id = kr.id and rae.name = :name and rae.value= :value";
        return this.em.createQuery(query, String.class).setParameter("roleNameVal", (Object)"shared_owner").setParameter("name", (Object)"scope").setParameter("value", (Object)"internal").getResultList();
    }

    public List<String> getProjectKeys() {
        String query = "SELECT c.clientId FROM  ClientEntity c , RoleEntity kr where kr.clientId = c.id and kr.name =:roleNameVal";
        return this.em.createQuery(query, String.class).setParameter("roleNameVal", (Object)"shared_owner").getResultList();
    }
}

