/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.service;

import eu.europeana.keycloak.KeycloakUtils;
import eu.europeana.keycloak.utils.Constants;
import eu.europeana.keycloak.validation.datamodel.ErrorMessage;
import eu.europeana.keycloak.validation.datamodel.SessionTracker;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public class SessionTrackerUpdater
implements BiFunction<String, SessionTracker, SessionTracker>,
Serializable {
    AtomicReference<ErrorMessage> resultReference = new AtomicReference();
    public static final int PERSONAL_KEY_LIMIT = KeycloakUtils.getEnvInt((String)"PERSONAL_KEY_RATE_LIMIT", (int)1000);
    public static final int PROJECT_KEY_LIMIT = KeycloakUtils.getEnvInt((String)"PROJECT_KEY_RATE_LIMIT", (int)10000);
    public static final int RATE_LIMIT_DURATION = KeycloakUtils.getEnvInt((String)"SESSION_DURATION_FOR_RATE_LIMITING", (int)60);
    private String lastAccessDate;
    private String keyType;

    public SessionTrackerUpdater(String lastAccessDate, String keyType) {
        this.lastAccessDate = lastAccessDate;
        this.keyType = keyType;
    }

    @Override
    public SessionTracker apply(String key, SessionTracker existingTracker) {
        SessionTracker tracker = existingTracker != null ? existingTracker : new SessionTracker(key, 0, this.lastAccessDate);
        this.resultReference.set(this.validateAndUpdateSessionTracker(tracker));
        return tracker;
    }

    private ErrorMessage validateAndUpdateSessionTracker(SessionTracker tracker) {
        int updatedCount = tracker.getSessionCount() + 1;
        if ("PersonalKey".equals(this.keyType)) {
            if (updatedCount > PERSONAL_KEY_LIMIT) {
                return this.personalKeyLimitReachedMessage();
            }
            this.updateSessionTracker(tracker, PERSONAL_KEY_LIMIT, updatedCount);
        }
        if ("ProjectKey".equals(this.keyType)) {
            if (updatedCount > PROJECT_KEY_LIMIT) {
                return this.projectKeyLimitReachedMessage();
            }
            this.updateSessionTracker(tracker, PROJECT_KEY_LIMIT, updatedCount);
        }
        return null;
    }

    private void updateSessionTracker(SessionTracker tracker, int maxKeyLimit, int updatedCount) {
        tracker.setSessionCount(updatedCount);
        tracker.setLastAccessDate(Constants.FORMATTER.format(LocalDateTime.now()));
        if (updatedCount == maxKeyLimit && tracker.getLastRateLimitReachingTime() == null) {
            tracker.setLastRateLimitReachingTime(tracker.getLastAccessDate());
        }
    }

    private ErrorMessage projectKeyLimitReachedMessage() {
        return ErrorMessage.LIMIT_PROJECT_KEYS_429.formatError(String.valueOf(PROJECT_KEY_LIMIT), String.valueOf(RATE_LIMIT_DURATION));
    }

    private ErrorMessage personalKeyLimitReachedMessage() {
        return ErrorMessage.LIMIT_PERSONAL_KEYS_429.formatError(String.valueOf(PERSONAL_KEY_LIMIT), String.valueOf(RATE_LIMIT_DURATION)).formatErrorMessage(String.valueOf(PERSONAL_KEY_LIMIT), String.valueOf(RATE_LIMIT_DURATION));
    }
}

