/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.service;

import eu.europeana.keycloak.validation.datamodel.Apikey;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class ListApiKeysService {
    private static final Logger LOG = Logger.getLogger(ListApiKeysService.class);

    public List<Apikey> getPrivateAndProjectkeys(UserModel userModel) {
        List<RoleModel> rolesAssociatedToUser = userModel.getRoleMappingsStream().filter(roleModel -> "client_owner".equals(roleModel.getName()) || "shared_owner".equals(roleModel.getName())).toList();
        return ListApiKeysService.gatherSortedApiKeyInfo(rolesAssociatedToUser);
    }

    private static List<Apikey> gatherSortedApiKeyInfo(List<RoleModel> roleModelList) {
        ArrayList<Apikey> personalKeys = new ArrayList<Apikey>();
        ArrayList<Apikey> projectKeys = new ArrayList<Apikey>();
        ListApiKeysService.gatherPersonalAndProjectKeys(roleModelList, personalKeys, projectKeys);
        personalKeys.sort(Comparator.comparing(Apikey::getCreated, Comparator.nullsLast(Comparator.reverseOrder())).reversed());
        projectKeys.sort(Comparator.comparing(Apikey::getCreated, Comparator.nullsLast(Comparator.reverseOrder())).reversed());
        personalKeys.addAll(projectKeys);
        return personalKeys;
    }

    private static void gatherPersonalAndProjectKeys(List<RoleModel> rolesAssociatedToUser, List<Apikey> personalKeys, List<Apikey> projectKeys) {
        for (RoleModel rolemodel : rolesAssociatedToUser) {
            Apikey apikey;
            if (!rolemodel.isClientRole() || (apikey = ListApiKeysService.getApikey(rolemodel)) == null) continue;
            ListApiKeysService.checkAndPopulateKeyList(personalKeys, projectKeys, apikey);
        }
    }

    private static void checkAndPopulateKeyList(List<Apikey> personalKeys, List<Apikey> projectKeys, Apikey apikey) {
        if ("PersonalKey".equals(apikey.getType())) {
            personalKeys.add(apikey);
        }
        if ("ProjectKey".equals(apikey.getType())) {
            projectKeys.add(apikey);
        }
    }

    private static Apikey getApikey(RoleModel rolemodel) {
        String clientState;
        ClientModel client = (ClientModel)rolemodel.getContainer();
        Date creationDate = ListApiKeysService.getUTCDate(rolemodel.getFirstAttribute("created"));
        String string = clientState = client.isEnabled() ? null : "disabled";
        if ("client_owner".equals(rolemodel.getName())) {
            return new Apikey(client.getId(), client.getClientId(), "PersonalKey", creationDate, null, null, clientState);
        }
        if ("shared_owner".equals(rolemodel.getName())) {
            return new Apikey(client.getId(), client.getClientId(), "ProjectKey", creationDate, client.getName(), client.getDescription(), clientState);
        }
        return null;
    }

    public static Date getUTCDate(String dateString) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC));
            return Date.from(zonedDateTime.toInstant());
        }
        catch (DateTimeParseException ex) {
            LOG.error((Object)("Exception occurred while parsing date : " + dateString + " returning null date \n" + String.valueOf(ex)));
            return null;
        }
    }
}

