/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.service;

import eu.europeana.keycloak.PassGenerator;
import eu.europeana.keycloak.validation.datamodel.Apikey;
import eu.europeana.keycloak.validation.exception.KeyCreationException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.UserModel;

public class KeyCloakClientCreationService {
    private static final Logger LOG = Logger.getLogger(KeyCloakClientCreationService.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final String clientID;
    private final String clientName;

    public KeyCloakClientCreationService(KeycloakSession session, String clientID, String clientName) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.clientID = clientID;
        this.clientName = clientName;
    }

    public Apikey registerKey(UserModel user, String keyType, String keyDescription) {
        Date creationDate;
        String apikey = this.clientID == null ? this.generateApikeyName() : this.clientID;
        ClientModel client = this.createNewKey(apikey, keyDescription);
        RoleModel clientRole = this.createClientRole(keyType, client, creationDate = new Date());
        if (clientRole != null) {
            user.grantRole(clientRole);
            return new Apikey(client.getId(), client.getClientId(), keyType, creationDate, client.getName(), client.getDescription(), null);
        }
        return null;
    }

    private RoleModel createClientRole(String keyType, ClientModel client, Date creationDate) {
        if ("PersonalKey".equals(keyType)) {
            return this.createOwnerRole(client, creationDate, "client_owner", "Ownership of this client");
        }
        if ("ProjectKey".equals(keyType)) {
            return this.createOwnerRole(client, creationDate, "shared_owner", "Shared ownership for this client (project keys)");
        }
        return null;
    }

    private ClientModel createNewKey(String clientID, String keyDescription) {
        try {
            ClientProvider clientProvider = this.session.clients();
            ClientModel client = clientProvider.addClient(this.realm, clientID);
            client.setName(this.clientName);
            client.setDescription(keyDescription);
            client.setProtocol("openid-connect");
            client.setPublicClient(true);
            client.setStandardFlowEnabled(false);
            client.setImplicitFlowEnabled(false);
            client.setDirectAccessGrantsEnabled(false);
            client.setServiceAccountsEnabled(false);
            client.setEnabled(true);
            LOG.info((Object)("Created new client : " + client.getName() + " " + client.getClientId()));
            return client;
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to create new Client !! " + ex.getMessage()));
            throw new KeyCreationException(ex.getMessage(), ex);
        }
    }

    private RoleModel createOwnerRole(ClientModel client, Date roleCreationDate, String roleName, String roleDescription) {
        try {
            RoleProvider roles = this.session.roles();
            RoleModel roleModel = roles.addClientRole(client, roleName);
            roleModel.setDescription(roleDescription);
            roleModel.setAttribute("created", List.of(this.getDateString(roleCreationDate)));
            return roleModel;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to create new role for client !! " + client.getClientId() + e.getMessage()));
            return null;
        }
    }

    private String getDateString(Date now) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
        return formatter.format(now.toInstant());
    }

    private String generateApikeyName() {
        String id;
        LOG.info((Object)"Generating new API key !!");
        ClientProvider clientProvider = this.session.clients();
        PassGenerator pg = new PassGenerator();
        while (clientProvider.getClientById(this.realm, id = pg.generate(RandomUtils.nextInt((int)8, (int)13))) != null) {
        }
        LOG.info((Object)("Created new API key : " + id));
        return id;
    }
}

