/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.service;

import eu.europeana.keycloak.timer.AbstractCustomScheduledTask;
import eu.europeana.keycloak.validation.datamodel.SessionTracker;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class ClearSessionTrackingCacheTask
extends AbstractCustomScheduledTask {
    private static final Logger LOG = Logger.getLogger(ClearSessionTrackingCacheTask.class);

    public String getTaskName() {
        return "clearSessionTrackingCache";
    }

    public void process(KeycloakSession session) {
        this.clearSessionTrackingCache(session);
    }

    private void clearSessionTrackingCache(KeycloakSession session) {
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionTrackerCache = provider.getCache("sessionTrackerCache");
        if (!sessionTrackerCache.isEmpty()) {
            this.updateClient(session, (Cache<String, SessionTracker>)sessionTrackerCache);
            sessionTrackerCache.clear();
            LOG.info((Object)"Infinispan cache 'sessionTrackerCache' is cleared");
        }
        LOG.info((Object)"Infinispan cache 'sessionTrackerCache' is already empty");
    }

    private void updateClient(KeycloakSession session, Cache<String, SessionTracker> sessionTrackerCache) {
        for (Map.Entry entry : sessionTrackerCache.entrySet()) {
            RealmModel europeanaRealm = session.realms().getRealm("europeana");
            if (europeanaRealm == null) {
                LOG.error((Object)"LastAccessDate not updated in cache. Realm not found - 'europeana'");
                return;
            }
            ClientModel client = session.clients().getClientByClientId(europeanaRealm, (String)entry.getKey());
            SessionTracker tracker = (SessionTracker)entry.getValue();
            if (client == null || tracker == null) continue;
            if (tracker.getLastAccessDate() != null) {
                ClearSessionTrackingCacheTask.updateClientRoleAtrribute(client, tracker.getLastAccessDate(), "lastAccess");
            }
            if (tracker.getLastRateLimitReachingTime() == null) continue;
            ClearSessionTrackingCacheTask.updateClientRoleAtrribute(client, tracker.getLastRateLimitReachingTime(), "rateLimitReached");
        }
    }

    private static void updateClientRoleAtrribute(ClientModel client, String valueToUpdate, String attributeToUpdate) {
        Stream.of("client_owner", "shared_owner").map(arg_0 -> ((ClientModel)client).getRole(arg_0)).filter(Objects::nonNull).forEach(roleModel -> roleModel.setAttribute(attributeToUpdate, List.of(valueToUpdate)));
    }
}

