/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.service;

import eu.europeana.keycloak.utils.Constants;
import eu.europeana.keycloak.validation.datamodel.ErrorMessage;
import eu.europeana.keycloak.validation.datamodel.ValidationResult;
import eu.europeana.keycloak.validation.service.SessionTrackerUpdater;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class ApiKeyValidationService {
    private static final Logger LOG = Logger.getLogger(ApiKeyValidationService.class);
    private final KeycloakSession session;
    private final RealmModel realm;

    public ApiKeyValidationService(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
    }

    public ValidationResult authorizeToken(String tokenString, String grantType) {
        AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)this.session.getContext().getUri(), (ClientConnection)this.session.getContext().getConnection(), (boolean)false, (boolean)true, null, (boolean)false, (String)tokenString, (HttpHeaders)this.session.getContext().getRequestHeaders(), (TokenVerifier.Predicate[])new TokenVerifier.Predicate[0]);
        if (authResult == null || authResult.getClient() == null) {
            return new ValidationResult(Response.Status.UNAUTHORIZED, ErrorMessage.TOKEN_INVALID_401);
        }
        if (!authResult.getToken().isActive()) {
            return new ValidationResult(Response.Status.UNAUTHORIZED, ErrorMessage.TOKEN_EXPIRED_401);
        }
        return this.validateClientScope(authResult, grantType);
    }

    private ValidationResult validateClientScope(AuthenticationManager.AuthResult authResult, String grantType) {
        ClientModel client = authResult.getClient();
        Map clientScopes = client.getClientScopes(true);
        if (clientScopes == null || !clientScopes.containsKey("apikeys")) {
            LOG.error((Object)("Client ID " + client.getClientId() + " is missing scope- apikeys"));
            return new ValidationResult(Response.Status.FORBIDDEN, ErrorMessage.SCOPE_MISSING_403);
        }
        return ApiKeyValidationService.validateTokenGrant(authResult, grantType);
    }

    private static ValidationResult validateTokenGrant(AuthenticationManager.AuthResult authResult, String grantType) {
        if (!ApiKeyValidationService.isValidGrantType(authResult, grantType)) {
            return new ValidationResult(Response.Status.FORBIDDEN, ErrorMessage.USER_MISSING_403);
        }
        ValidationResult result = new ValidationResult(Response.Status.OK, null);
        result.setUser(authResult.getUser());
        return result;
    }

    private static boolean isValidGrantType(AuthenticationManager.AuthResult authResult, String grantType) {
        if ("password".equals(grantType)) {
            return authResult.getToken().getOtherClaims().get("client_id") == null;
        }
        if ("client_credentials".equals(grantType)) {
            return authResult.getToken().getOtherClaims().get("client_id") != null;
        }
        return true;
    }

    public boolean validateApikeyLegacy(String apikey) {
        ClientProvider clientProvider = this.session.clients();
        ClientModel client = clientProvider.getClientByClientId(this.realm, apikey);
        if (client == null) {
            LOG.error((Object)String.format("API key %s is not registered", apikey));
            return false;
        }
        if (!client.isEnabled()) {
            LOG.error((Object)String.format("API key %s is not active", client.getClientId()));
            return false;
        }
        return true;
    }

    public ValidationResult validateClient(ClientModel client) {
        if (client == null) {
            return new ValidationResult(Response.Status.BAD_REQUEST, ErrorMessage.KEY_INVALID_401);
        }
        if (!client.isEnabled()) {
            return new ValidationResult(Response.Status.BAD_REQUEST, ErrorMessage.KEY_DISABLED_401);
        }
        return new ValidationResult(Response.Status.OK, null);
    }

    public ValidationResult performRateLimitCheck(ClientModel client) {
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionTrackerCache = provider.getCache("sessionTrackerCache");
        if (sessionTrackerCache == null) {
            LOG.error((Object)"Infinispan cache sessionTrackerCache not found. Cannot perform rate limit check");
            return new ValidationResult(Response.Status.OK, null);
        }
        String keyType = this.getKeyType(client);
        if (StringUtils.isEmpty((CharSequence)keyType)) {
            return new ValidationResult(Response.Status.OK, null);
        }
        SessionTrackerUpdater updater = new SessionTrackerUpdater(Constants.FORMATTER.format(LocalDateTime.now()), keyType);
        sessionTrackerCache.compute((Object)client.getClientId(), (BiFunction)updater);
        ErrorMessage errorMessage = updater.resultReference.get();
        Response.Status status = errorMessage != null ? Response.Status.TOO_MANY_REQUESTS : Response.Status.OK;
        return new ValidationResult(status, errorMessage);
    }

    private String getKeyType(ClientModel client) {
        if (client.getRole("client_owner") != null) {
            return "PersonalKey";
        }
        if (client.getRole("shared_owner") != null) {
            return "ProjectKey";
        }
        return "";
    }

    public String extractApikeyFromAuthorizationHeader(HttpRequest httpRequest) {
        String authorization;
        HttpHeaders httpHeaders = httpRequest.getHttpHeaders();
        String string = authorization = httpHeaders != null ? httpHeaders.getHeaderString("Authorization") : null;
        if (authorization != null) {
            try {
                Pattern pattern = Pattern.compile("APIKEY\\s+([^\\s]+)");
                Matcher matcher = pattern.matcher(authorization);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Regex problem while parsing authorization header", (Throwable)e);
            }
        }
        LOG.error((Object)"No Apikey found in request header!");
        return null;
    }

    public ValidationResult validateAuthToken(String grantType) {
        HttpHeaders headers = this.session.getContext().getHttpRequest().getHttpHeaders();
        String authHeader = AppAuthManager.extractAuthorizationHeaderToken((HttpHeaders)headers);
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            return new ValidationResult(Response.Status.UNAUTHORIZED, ErrorMessage.TOKEN_MISSING_401);
        }
        return this.authorizeToken(authHeader, grantType);
    }
}

