/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.provider;

import eu.europeana.keycloak.validation.datamodel.ValidationResult;
import eu.europeana.keycloak.validation.service.ApiKeyValidationService;
import eu.europeana.keycloak.validation.service.ListApiKeysService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.Cors;

public class UserApiKeysProvider
implements RealmResourceProvider {
    private final ApiKeyValidationService validationService;
    private final ListApiKeysService listKeysService;
    private final KeycloakSession session;
    private Cors cors;

    public UserApiKeysProvider(KeycloakSession keycloakSession) {
        this.session = keycloakSession;
        this.validationService = new ApiKeyValidationService(keycloakSession);
        this.listKeysService = new ListApiKeysService();
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @Path(value="/clients")
    @GET
    @Produces(value={"application/json"})
    public Response getKeysAssociatedToUser() {
        this.setupCors();
        ValidationResult result = this.validationService.validateAuthToken("password");
        if (result.getErrorResponse() != null) {
            return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
        }
        return this.cors.builder(Response.ok().entity(this.listKeysService.getPrivateAndProjectkeys(result.getUser()))).build();
    }

    @Path(value="/clients")
    @OPTIONS
    public Response getKeysAssociatedToUserPreflight() {
        return Cors.add((HttpRequest)this.session.getContext().getHttpRequest(), (Response.ResponseBuilder)Response.ok()).auth().allowedMethods(new String[]{"GET"}).preflight().build();
    }

    private void setupCors() {
        this.cors = Cors.add((HttpRequest)this.session.getContext().getHttpRequest()).auth().allowedMethods(new String[]{"GET"}).exposedHeaders(new String[]{"Allow"}).allowAllOrigins();
    }
}

