/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.provider;

import eu.europeana.keycloak.KeycloakUtils;
import eu.europeana.keycloak.timer.AbstractCustomScheduledTask;
import eu.europeana.keycloak.timer.FixedRateTaskScheduler;
import eu.europeana.keycloak.validation.provider.CustomAdminResourceProvider;
import eu.europeana.keycloak.validation.service.ClearSessionTrackingCacheTask;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

public class CustomAdminResourceProviderFactory
implements RealmResourceProviderFactory {
    public static final String PROVIDER_ID = "admin";
    private static final Logger LOG = Logger.getLogger(CustomAdminResourceProviderFactory.class);

    public RealmResourceProvider create(KeycloakSession keycloakSession) {
        return new CustomAdminResourceProvider(keycloakSession);
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
        int intervalMinutes = KeycloakUtils.getEnvInt((String)"SESSION_DURATION_FOR_RATE_LIMITING", (int)60);
        LOG.info((Object)("Configured Session Duration - " + intervalMinutes));
        if (intervalMinutes < 0 || intervalMinutes > 60) {
            LOG.info((Object)"Session duration not valid, defaulting to 60 minutes");
        }
        FixedRateTaskScheduler scheduler = new FixedRateTaskScheduler((AbstractCustomScheduledTask)new ClearSessionTrackingCacheTask(), intervalMinutes);
        scheduler.scheduleTask(keycloakSessionFactory);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

