/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.provider;

import eu.europeana.keycloak.repo.CustomClientRepository;
import eu.europeana.keycloak.validation.datamodel.Apikey;
import eu.europeana.keycloak.validation.datamodel.ErrorMessage;
import eu.europeana.keycloak.validation.datamodel.SessionTracker;
import eu.europeana.keycloak.validation.datamodel.ValidationResult;
import eu.europeana.keycloak.validation.service.ApiKeyValidationService;
import eu.europeana.keycloak.validation.service.KeyCloakClientCreationService;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.Cache;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.Cors;

public class CustomAdminResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final ApiKeyValidationService service;
    private Cors cors;

    public CustomAdminResourceProvider(KeycloakSession keycloakSession) {
        this.session = keycloakSession;
        this.service = new ApiKeyValidationService(this.session);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @Path(value="/client")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createProjectKey() {
        this.setupCors("POST");
        ValidationResult result = this.service.validateAuthToken("password");
        if (!result.isSuccess()) {
            return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
        }
        UserModel userModel = result.getUser();
        if (userModel.getRoleMappingsStream().noneMatch(p -> "admin".equals(p.getName()))) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorMessage.USER_NOT_AUTHORIZED_403)).build();
        }
        MultivaluedMap decodedFormParameters = this.session.getContext().getHttpRequest().getDecodedFormParameters();
        UserModel userForKeyCreation = this.session.users().getUserByEmail(this.session.getContext().getRealm(), (String)decodedFormParameters.getFirst((Object)"email"));
        if (!"ProjectKey".equals(decodedFormParameters.getFirst((Object)"type")) || StringUtils.isBlank((CharSequence)((CharSequence)decodedFormParameters.getFirst((Object)"name"))) || userForKeyCreation == null) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.BAD_REQUEST)).build();
        }
        KeyCloakClientCreationService clientCreationService = new KeyCloakClientCreationService(this.session, null, (String)decodedFormParameters.getFirst((Object)"name"));
        Apikey apikey = clientCreationService.registerKey(userForKeyCreation, "ProjectKey", null);
        return this.cors.builder(Response.status((Response.Status)Response.Status.OK).entity((Object)apikey)).build();
    }

    @Path(value="/sessioncount")
    @GET
    public Response viewCache() {
        this.setupCors("GET");
        try {
            ValidationResult result = this.service.validateAuthToken("password");
            if (!result.isSuccess()) {
                return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
            }
            UserModel userModel = result.getUser();
            if (userModel.getRoleMappingsStream().noneMatch(p -> "admin".equals(p.getName()))) {
                return this.cors.builder(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorMessage.USER_NOT_AUTHORIZED_403)).build();
            }
            return this.getCachedSessionDetails();
        }
        catch (Exception e) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR)).build();
        }
    }

    private Response getCachedSessionDetails() {
        JsonObjectBuilder cachedObject = Json.createObjectBuilder();
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionTrackerCache = provider.getCache("sessionTrackerCache");
        for (Map.Entry entry : sessionTrackerCache.entrySet()) {
            JsonObjectBuilder details = Json.createObjectBuilder();
            details.add("sessionCount", ((SessionTracker)entry.getValue()).getSessionCount());
            details.add("LastAccessDate", ((SessionTracker)entry.getValue()).getLastAccessDate());
            details.add("rateLimitReached", (String)StringUtils.getIfEmpty((CharSequence)((SessionTracker)entry.getValue()).getLastRateLimitReachingTime(), () -> ""));
            cachedObject.add((String)entry.getKey(), details);
        }
        return this.cors.builder(Response.status((Response.Status)Response.Status.OK).entity((Object)cachedObject.build().toString())).build();
    }

    private void setupCors(String allowedMethod) {
        this.cors = Cors.add((HttpRequest)this.session.getContext().getHttpRequest()).auth().allowedMethods(new String[]{allowedMethod}).exposedHeaders(new String[]{"Allow"}).allowAllOrigins();
    }

    @Path(value="/client")
    @OPTIONS
    public Response createProjectKeyPreflight() {
        return Cors.add((HttpRequest)this.session.getContext().getHttpRequest(), (Response.ResponseBuilder)Response.ok()).auth().allowedMethods(new String[]{"POST"}).preflight().build();
    }

    @Path(value="/client")
    @GET
    public Response getRegisteredClients() {
        this.setupCors("GET");
        ValidationResult result = this.service.validateAuthToken(null);
        if (!result.isSuccess()) {
            return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
        }
        EntityManager entityManager = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        CustomClientRepository clientRepo = new CustomClientRepository(entityManager);
        List internal = clientRepo.getInternalKeys();
        List projects = clientRepo.getProjectKeys();
        projects.removeAll(internal);
        JsonObject registeredClients = Json.createObjectBuilder().add("projects", Json.createArrayBuilder((Collection)projects)).add("internal", Json.createArrayBuilder((Collection)internal)).build();
        return this.cors.builder(Response.status((Response.Status)Response.Status.OK).entity((Object)registeredClients.toString())).build();
    }
}

