/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.provider;

import eu.europeana.keycloak.validation.datamodel.Apikey;
import eu.europeana.keycloak.validation.datamodel.ErrorMessage;
import eu.europeana.keycloak.validation.datamodel.ValidationResult;
import eu.europeana.keycloak.validation.service.ApiKeyValidationService;
import eu.europeana.keycloak.validation.service.KeyCloakClientCreationService;
import eu.europeana.keycloak.validation.service.ListApiKeysService;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.Cors;

public class ApiKeyValidationProvider
implements RealmResourceProvider {
    public static final int ALLOWED_NUMBER_OF_DISABLED_KEYS = 3;
    private final KeycloakSession session;
    private final ApiKeyValidationService service;
    private final ListApiKeysService listKeysService;
    private Cors cors;

    public ApiKeyValidationProvider(KeycloakSession keycloakSession) {
        this.session = keycloakSession;
        this.service = new ApiKeyValidationService(this.session);
        this.listKeysService = new ListApiKeysService();
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @Path(value="/validate")
    @POST
    public Response validateApiKey(@QueryParam(value="client_id") String clientId) {
        ValidationResult result = this.service.validateAuthToken(null);
        ClientModel client = this.session.clients().getClientByClientId(this.session.getContext().getRealm(), clientId);
        if (result.getErrorResponse() == null) {
            result = this.service.validateClient(client);
        }
        if (result.getErrorResponse() == null) {
            result = this.service.performRateLimitCheck(client);
        }
        if (result != null && result.getErrorResponse() != null) {
            return Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse()).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/{clientPublicId}")
    @DELETE
    public Response disableApikey(@PathParam(value="clientPublicId") String clientPublicID) {
        this.setupCors("DELETE");
        ValidationResult result = this.service.validateAuthToken("password");
        if (!result.isSuccess()) {
            return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
        }
        return this.checkAndDisableApiKey(clientPublicID, result.getUser());
    }

    @Path(value="/{clientPublicId}")
    @OPTIONS
    public Response disableApikeyPreflight() {
        return Cors.add((HttpRequest)this.session.getContext().getHttpRequest(), (Response.ResponseBuilder)Response.ok()).auth().allowedMethods(new String[]{"DELETE"}).preflight().build();
    }

    private Response checkAndDisableApiKey(String clientPublicID, UserModel user) {
        ClientModel clientToBeDisabled = this.session.clients().getClientById(this.session.getContext().getRealm(), clientPublicID);
        if (clientToBeDisabled == null) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorMessage.CLIENT_UNKNOWN_404)).build();
        }
        List<Apikey> clientList = this.listKeysService.getPrivateAndProjectkeys(user);
        if (clientList.stream().noneMatch(apikey -> apikey.getId().equals(clientToBeDisabled.getId()))) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorMessage.USER_NOT_AUTHORIZED_403)).build();
        }
        if (!clientToBeDisabled.isEnabled()) {
            return this.cors.builder(Response.status((Response.Status)Response.Status.GONE).entity((Object)ErrorMessage.CLIENT_ALREADY_DISABLED_410)).build();
        }
        clientToBeDisabled.setEnabled(false);
        return this.cors.builder(Response.status((Response.Status)Response.Status.NO_CONTENT)).build();
    }

    @Path(value="")
    @POST
    public Response registerPersonalKey() {
        this.setupCors("POST");
        ValidationResult result = this.service.validateAuthToken("password");
        if (!result.isSuccess()) {
            return this.cors.builder(Response.status((Response.Status)result.getHttpStatus()).entity((Object)result.getErrorResponse())).build();
        }
        UserModel userModel = result.getUser();
        List<ClientModel> personalKeys = ApiKeyValidationProvider.getPersonalKeys(userModel);
        if (!personalKeys.isEmpty()) {
            if (personalKeys.stream().anyMatch(ClientModel::isEnabled)) {
                return this.cors.builder(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorMessage.DUPLICATE_KEY_400)).build();
            }
            if (personalKeys.stream().filter(p -> !p.isEnabled()).count() == 3L) {
                return this.cors.builder(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorMessage.KEY_LIMIT_REACHED_400)).build();
            }
        }
        KeyCloakClientCreationService clientCreationService = new KeyCloakClientCreationService(this.session, null, userModel.getUsername());
        Apikey apikey = clientCreationService.registerKey(userModel, "PersonalKey", "Private key for individual use only");
        return this.cors.builder(Response.status((Response.Status)Response.Status.OK).entity((Object)apikey)).build();
    }

    @Path(value="")
    @OPTIONS
    public Response registerPersonalKeyPreflight() {
        return Cors.add((HttpRequest)this.session.getContext().getHttpRequest(), (Response.ResponseBuilder)Response.ok()).auth().allowedMethods(new String[]{"POST"}).preflight().build();
    }

    private static List<ClientModel> getPersonalKeys(UserModel userModel) {
        List<RoleModel> clientOwnerRoles = userModel.getRoleMappingsStream().filter(roleModel -> "client_owner".equals(roleModel.getName())).toList();
        ArrayList<ClientModel> clientList = new ArrayList<ClientModel>();
        clientOwnerRoles.forEach(p -> clientList.add((ClientModel)p.getContainer()));
        return clientList;
    }

    private void setupCors(String allowedMethod) {
        this.cors = Cors.add((HttpRequest)this.session.getContext().getHttpRequest()).auth().allowedMethods(new String[]{allowedMethod}).exposedHeaders(new String[]{"Allow"}).allowAllOrigins();
    }
}

