/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.provider;

import eu.europeana.keycloak.validation.datamodel.ErrorResponseLegacy;
import eu.europeana.keycloak.validation.service.ApiKeyValidationService;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resource.RealmResourceProvider;

public class ApiKeyLegacyValidationProvider
implements RealmResourceProvider {
    public static final String APIKEY_MISSING = "No API key in header. Correct header syntax 'Authorization: APIKEY <your_key_here>'";
    public static final String APIKEY_NOT_REGISTERED = "\"API key %s is not registered\"";
    private final KeycloakSession session;
    private final ApiKeyValidationService service;

    public ApiKeyLegacyValidationProvider(KeycloakSession keycloakSession) {
        this.session = keycloakSession;
        this.service = new ApiKeyValidationService(this.session);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @Path(value="")
    @POST
    public Response validateApiKeyLegacy() {
        HttpRequest httpRequest = this.session.getContext().getHttpRequest();
        String apikey = this.service.extractApikeyFromAuthorizationHeader(httpRequest);
        if (StringUtils.isBlank((CharSequence)apikey)) {
            ErrorResponseLegacy errorResponse = new ErrorResponseLegacy(Response.Status.BAD_REQUEST.getStatusCode(), Response.Status.BAD_REQUEST.getReasonPhrase(), APIKEY_MISSING, httpRequest.getUri().getPath());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
        }
        if (!this.service.validateApikeyLegacy(apikey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)String.format(APIKEY_NOT_REGISTERED, apikey)).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

