/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.keycloak.validation.datamodel;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@JsonPropertyOrder(value={"success", "status", "error", "message", "timestamp", "path"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ErrorResponseLegacy {
    private final boolean success = false;
    private final int status;
    private final String error;
    private final String message;
    private final String path;
    private final OffsetDateTime timestamp = OffsetDateTime.now();

    public ErrorResponseLegacy(int status, String error, String message, String path) {
        this.status = status;
        this.error = error;
        this.message = message;
        this.path = path;
    }

    public String getTimestamp() {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return fmt.format(this.timestamp);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPath() {
        return this.path;
    }
}

