/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.solr;

import eu.europeana.fulltext.exception.SolrServiceException;
import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.springframework.util.CollectionUtils;

public class SolrUtils {
    private static final Logger log = LogManager.getLogger(FulltextSolrService.class);

    static Optional<Instant> getMostRecentValue(SolrClient solrClient, String timestampField) throws SolrServiceException {
        QueryResponse response;
        SolrQuery lastUpdateTimeQuery = new SolrQuery("*:*").addField(timestampField).setRows(Integer.valueOf(1)).setSort(timestampField, SolrQuery.ORDER.desc);
        try {
            response = solrClient.query((SolrParams)lastUpdateTimeQuery);
            if (log.isDebugEnabled()) {
                log.debug("Performed Fulltext Solr search query in {}ms:  query={}", (Object)response.getElapsedTime(), (Object)lastUpdateTimeQuery);
            }
        }
        catch (IOException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error while searching Fulltext Solr for lastUpdateTime. query=%s", lastUpdateTimeQuery.toString()), ex);
        }
        if (response == null || CollectionUtils.isEmpty((Collection)response.getResults())) {
            return Optional.empty();
        }
        Date fieldValue = (Date)((SolrDocument)response.getResults().get(0)).getFieldValue(timestampField);
        return Optional.of(fieldValue.toInstant());
    }
}

