/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.solr;

import eu.europeana.fulltext.indexing.IndexingConstants;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SolrSearchCursorIterator
implements Iterator<SolrDocumentList> {
    private static final Logger LOGGER = LogManager.getLogger(SolrSearchCursorIterator.class);
    private final SolrClient client;
    private final SolrQuery solrQuery;
    private String cursorMark;
    private String previousCursorMark;

    public SolrSearchCursorIterator(SolrClient client, SolrQuery solrQuery) {
        this.validateQueryFields(solrQuery);
        this.ensureSortClause(solrQuery);
        this.solrQuery = solrQuery;
        this.client = client;
        this.cursorMark = "*";
    }

    @Override
    public boolean hasNext() {
        return !this.cursorMark.equals(this.previousCursorMark);
    }

    @Override
    public SolrDocumentList next() {
        this.solrQuery.set("cursorMark", new String[]{this.cursorMark});
        QueryResponse response = null;
        int attempts = IndexingConstants.ATTEMPTS;
        while (attempts > 0) {
            try {
                response = this.client.query((SolrParams)this.solrQuery);
                break;
            }
            catch (IOException | SolrServerException ex) {
                if (--attempts <= 0) {
                    throw new IllegalStateException(String.format("Error while searching Solr q=%s", this.solrQuery.getQuery()), ex);
                }
                try {
                    Thread.sleep(IndexingConstants.SLEEP_MS);
                }
                catch (InterruptedException e1) {
                    throw new IllegalStateException("Error while searching Solr", e1);
                }
            }
        }
        this.previousCursorMark = this.cursorMark;
        this.cursorMark = response.getNextCursorMark();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performed Solr search query in {}ms: numFound={}, cursorMark={}, q={}", (Object)response.getElapsedTime(), (Object)response.getResults().getNumFound(), (Object)this.cursorMark, (Object)this.solrQuery.getQuery());
        }
        return response.getResults();
    }

    public SolrQuery getQuery() {
        return this.solrQuery;
    }

    private void validateQueryFields(SolrQuery solrQuery) {
        String fieldString = solrQuery.getFields();
        if (!StringUtils.hasLength((String)fieldString)) {
            return;
        }
        List<String> fields = Arrays.asList(fieldString.split(","));
        if (!fields.contains("europeana_id")) {
            throw new IllegalArgumentException("SolrQuery fields must either be empty or contain europeana_id");
        }
    }

    private void ensureSortClause(SolrQuery solrQuery) {
        if (CollectionUtils.isEmpty((Collection)solrQuery.getSorts())) {
            throw new IllegalArgumentException("SolrQuery must specify a sort with a unique field");
        }
    }
}

