/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.solr;

import eu.europeana.fulltext.exception.SolrServiceException;
import eu.europeana.fulltext.indexing.IndexingConstants;
import eu.europeana.fulltext.indexing.config.IndexingAppSettings;
import eu.europeana.fulltext.indexing.solr.SolrSearchCursorIterator;
import eu.europeana.fulltext.indexing.solr.SolrUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.response.schema.SchemaRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FulltextSolrService
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(FulltextSolrService.class);
    private final SolrClient fulltextSolr;
    private final int commitWithinMs;
    private final int retryLimit;
    private SchemaRepresentation schema;
    private final int metadataSolrSyncPageSize;

    public FulltextSolrService(@Qualifier(value="fulltextSolr") SolrClient fulltextSolr, IndexingAppSettings settings) {
        this.fulltextSolr = fulltextSolr;
        this.retryLimit = settings.getRetryLimit();
        this.metadataSolrSyncPageSize = settings.getMetadataSolrSyncPageSize();
        this.commitWithinMs = settings.getCommitWithinMs();
    }

    public Optional<Instant> getMostRecentValue(String timestampField) throws SolrServiceException {
        return SolrUtils.getMostRecentValue((SolrClient)this.fulltextSolr, (String)timestampField);
    }

    public boolean existsByEuropeanaId(String europeanaId) throws SolrServiceException {
        int attempts = this.retryLimit;
        SolrQuery query = new SolrQuery("europeana_id:\"" + europeanaId + "\"").addField("europeana_id");
        while (attempts > 0) {
            try {
                QueryResponse response = this.fulltextSolr.query((SolrParams)query);
                return response != null && !CollectionUtils.isEmpty((Collection)response.getResults());
            }
            catch (IOException | SolrServerException ex) {
                if (--attempts <= 0) {
                    throw new SolrServiceException(String.format("Error while checking for existing europeanaId. query=%s", query.toString()), ex);
                }
                try {
                    Thread.sleep(IndexingConstants.SLEEP_MS);
                }
                catch (InterruptedException e1) {
                    throw new SolrServiceException("Error while checking for existing europeanaId", (Throwable)e1);
                }
            }
        }
        return false;
    }

    public void writeToSolr(List<SolrInputDocument> documents) throws SolrServiceException {
        int attempts = this.retryLimit;
        while (attempts > 0) {
            try {
                UpdateResponse response = this.fulltextSolr.add(documents, this.commitWithinMs);
                if (!log.isDebugEnabled()) break;
                log.debug("Wrote {} docs to Fulltext Solr in {}ms; commitWithinMs={}", (Object)documents.size(), (Object)response.getElapsedTime(), (Object)this.commitWithinMs);
                break;
            }
            catch (IOException | SolrServerException e) {
                if (--attempts <= 0) {
                    throw new SolrServiceException("Exception during Solr insertion", e);
                }
                try {
                    Thread.sleep(IndexingConstants.SLEEP_MS);
                }
                catch (InterruptedException e1) {
                    throw new SolrServiceException("Exception during Solr insertion", (Throwable)e1);
                }
            }
        }
    }

    public void deleteFromSolr(List<String> europeanaIds) throws SolrServiceException {
        if (europeanaIds == null || europeanaIds.isEmpty()) {
            return;
        }
        int attempts = this.retryLimit;
        while (attempts > 0) {
            try {
                UpdateResponse response = this.fulltextSolr.deleteById(europeanaIds, this.commitWithinMs);
                if (!log.isDebugEnabled()) break;
                log.debug("Deleted {} docs from Fulltext Solr in {}ms; commitWithinMs={}", (Object)europeanaIds.size(), (Object)response.getElapsedTime(), (Object)this.commitWithinMs);
                break;
            }
            catch (IOException | SolrServerException e) {
                if (--attempts <= 0) {
                    throw new SolrServiceException("Exception during Solr deletion", e);
                }
                try {
                    Thread.sleep(IndexingConstants.SLEEP_MS);
                }
                catch (InterruptedException e1) {
                    throw new SolrServiceException("Exception during Solr deletion", (Throwable)e1);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        SchemaRequest request = new SchemaRequest();
        SchemaResponse response = (SchemaResponse)request.process(this.fulltextSolr);
        this.schema = response.getSchemaRepresentation();
    }

    public SchemaRepresentation getSchema() {
        return this.schema;
    }

    public SolrSearchCursorIterator createFulltextSyncIterator(String ... fields) {
        return new SolrSearchCursorIterator(this.fulltextSolr, new SolrQuery("*:*").setRows(Integer.valueOf(this.metadataSolrSyncPageSize)).setFields(fields).setSort("europeana_id", SolrQuery.ORDER.asc));
    }

    public SolrDocument getDocument(String europeanaId) throws SolrServiceException {
        SolrQuery query = new SolrQuery("europeana_id:\"" + europeanaId + "\"").addField("*");
        try {
            QueryResponse response = this.fulltextSolr.query((SolrParams)query);
            if (log.isDebugEnabled()) {
                log.debug("Performed Fulltext query in {}ms:  query={}", (Object)response.getElapsedTime(), (Object)query);
            }
            if (response != null && !response.getResults().isEmpty()) {
                return (SolrDocument)response.getResults().get(0);
            }
        }
        catch (IOException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error while searching Solr for fulltext document. query=%s", query.toString()), ex);
        }
        return new SolrDocument();
    }
}

