/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.repository;

import dev.morphia.aggregation.experimental.Aggregation;
import dev.morphia.aggregation.experimental.AggregationOptions;
import dev.morphia.aggregation.experimental.expressions.Expressions;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.aggregation.experimental.stages.Group;
import dev.morphia.aggregation.experimental.stages.ReplaceRoot;
import dev.morphia.aggregation.experimental.stages.Sort;
import dev.morphia.query.MorphiaCursor;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.repository.AnnoPageRepository;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository
public class IndexingAnnoPageRepository
extends AnnoPageRepository {
    private static final int MONGO_BATCH_SIZE = 300;
    private final AggregationOptions aggregationOpts = new AggregationOptions().allowDiskUse(true).batchSize(300);
    private static final List<String> PROJECTION_FIELDS = List.of("dsId", "lcId", "pgId", "tgtId", "lang", "modified", "res", "deleted");

    public List<AnnoPage> getAnnoPagesWithProjection(String dsId, String lcId) {
        return super.findAnnoPages(dsId, lcId, PROJECTION_FIELDS);
    }

    public boolean existsActive(String dsId, String lcId) {
        return this.datastore.find(AnnoPage.class).filter(new Filter[]{Filters.eq((String)"dsId", (Object)dsId), Filters.eq((String)"lcId", (Object)lcId), Filters.eq((String)"deleted", null)}).count() > 0L;
    }

    public MorphiaCursor<AnnoPageRecordId> getAnnoPageRecordIdByModificationTime(Optional<Instant> from) {
        Aggregation query = this.datastore.aggregate(AnnoPage.class);
        from.ifPresent(instant -> query.match(new Filter[]{Filters.gt((String)"modified", (Object)instant)}));
        query.sort(Sort.sort().ascending("dsId", new String[0]).ascending("lcId", new String[0])).group(Group.group((Group.GroupId)Group.id().field("dsId").field("lcId"))).replaceRoot(ReplaceRoot.replaceRoot((Expression)Expressions.field((String)"_id")));
        return query.execute(AnnoPageRecordId.class, this.aggregationOpts);
    }
}

