/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.reader;

import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import eu.europeana.fulltext.indexing.solr.SolrSearchCursorIterator;
import java.util.Collections;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class FulltextSolrDocumentReader
extends AbstractPaginatedDataItemReader<SolrDocument> {
    private SolrSearchCursorIterator solrIterator;
    private final Logger logger = LogManager.getLogger(FulltextSolrDocumentReader.class);
    private final FulltextSolrService fulltextSolr;

    public FulltextSolrDocumentReader(FulltextSolrService fulltextSolr) {
        this.fulltextSolr = fulltextSolr;
    }

    protected Iterator<SolrDocument> doPageRead() {
        if (this.solrIterator.hasNext()) {
            return this.solrIterator.next().iterator();
        }
        return Collections.emptyIterator();
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setSaveState(false);
        this.setName(FulltextSolrDocumentReader.class.getName());
        if (this.solrIterator == null) {
            this.solrIterator = this.fulltextSolr.createFulltextSyncIterator(new String[]{"europeana_id", "timestamp_update"});
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created Solr iterator for fetching all documents in Fulltext. Query={}", (Object)this.solrIterator.getQuery());
            }
        }
    }
}

