/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.exception.SolrServiceException;
import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProcessorUtils {
    private static final Logger LOGGER = LogManager.getLogger(ProcessorUtils.class);

    private ProcessorUtils() {
    }

    public static SolrInputDocument toSolrInputDocument(SolrDocument d) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (String name : d.getFieldNames()) {
            doc.addField(name, d.getFieldValue(name));
        }
        return doc;
    }

    public static void mergeDocs(SolrDocument metadataDoc, SolrInputDocument destinationDoc, String europeanaId, FulltextSolrService fulltextSolrService) throws SolrServiceException {
        destinationDoc.setField("europeana_id", (Object)europeanaId);
        HashSet metadataFields = new HashSet(metadataDoc.getFieldNames());
        HashSet fulltextFields = new HashSet(fulltextSolrService.getDocument(europeanaId).getFieldNames());
        fulltextFields.removeAll(metadataFields);
        for (String field : fulltextFields) {
            if (!ProcessorUtils.doAtomicRemoval((String)field)) continue;
            destinationDoc.setField(field, Map.of("removeregex", ".*"));
        }
        for (String field : metadataFields) {
            if (field.equals("proxy_dcterms_issued")) {
                Collection listIssuedDates = metadataDoc.getFieldValues("proxy_dcterms_issued");
                ArrayList<String> isoDates = new ArrayList<String>();
                for (Object d : listIssuedDates) {
                    try {
                        LocalDate localDate = LocalDate.parse(d.toString());
                        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.of("Z"));
                        isoDates.add(zonedDateTime.format(DateTimeFormatter.ISO_INSTANT));
                    }
                    catch (DateTimeException e) {
                        LOGGER.warn("Error while converting date - {} into a ISO Format. {}", d, (Object)e);
                    }
                }
                if (!isoDates.isEmpty()) {
                    destinationDoc.addField("issued", Map.of("set", isoDates));
                }
                destinationDoc.addField(field, Map.of("set", metadataDoc.getFieldValue(field)));
                continue;
            }
            if (field.equals("is_fulltext")) {
                destinationDoc.addField(field, Map.of("set", true));
                continue;
            }
            if (field.equals("timestamp_update")) {
                destinationDoc.setField(field, metadataDoc.getFieldValue("timestamp_update"));
                continue;
            }
            if (field.equals("europeana_id") || field.equals("timestamp") || field.equals("_version_")) continue;
            destinationDoc.addField(field, Map.of("set", metadataDoc.getFieldValue(field)));
        }
    }

    private static boolean doAtomicRemoval(String field) {
        return !field.equals("proxy_dcterms_issued") && !field.equals("timestamp_update_fulltext") && !field.startsWith("fulltext") && !field.equals("is_fulltext");
    }
}

