/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingAction;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import eu.europeana.fulltext.indexing.repository.IndexingAnnoPageRepository;
import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
public class FulltextIndexingWrapperCreator
implements ItemProcessor<AnnoPageRecordId, IndexingWrapper> {
    private final IndexingAnnoPageRepository repository;
    private final FulltextSolrService fulltextSolrService;

    public FulltextIndexingWrapperCreator(IndexingAnnoPageRepository repository, FulltextSolrService fulltextSolrService) {
        this.repository = repository;
        this.fulltextSolrService = fulltextSolrService;
    }

    public IndexingWrapper process(AnnoPageRecordId recordId) throws Exception {
        boolean active = this.repository.existsActive(recordId.getDsId(), recordId.getLcId());
        boolean exists = this.fulltextSolrService.existsByEuropeanaId(recordId.toEuropeanaId());
        IndexingWrapper actionWrapper = null;
        if (active && !exists) {
            actionWrapper = new IndexingWrapper(recordId, new IndexingAction[]{IndexingAction.UPDATE_FULLTEXT_FIELDS, IndexingAction.UPDATE_METADATA_FIELDS, IndexingAction.WRITE_DOCUMENT});
        } else if (active && exists) {
            actionWrapper = new IndexingWrapper(recordId, new IndexingAction[]{IndexingAction.UPDATE_FULLTEXT_FIELDS, IndexingAction.WRITE_DOCUMENT});
        } else if (!active && exists) {
            actionWrapper = new IndexingWrapper(recordId, new IndexingAction[]{IndexingAction.DELETE_DOCUMENT});
        }
        return actionWrapper;
    }
}

