/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.config;

import eu.europeana.fulltext.indexing.config.IndexingAppSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class IndexingBatchBean {
    private final IndexingAppSettings config;

    public IndexingBatchBean(IndexingAppSettings config) {
        this.config = config;
    }

    @Bean(value={"batchThreadExecutor"})
    public TaskExecutor indexingThreadExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.config.getBatchCorePoolSize());
        taskExecutor.setMaxPoolSize(this.config.getBatchMaxPoolSize());
        taskExecutor.setQueueCapacity(this.config.getBatchQueueSize());
        return taskExecutor;
    }
}

