/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing;

import eu.europeana.fulltext.indexing.IndexingBatchConfig;
import eu.europeana.fulltext.indexing.model.IndexingJobType;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"eu.europeana.fulltext"}, exclude={SecurityAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
public class IndexingApplication
implements CommandLineRunner {
    private static final Logger logger = LogManager.getLogger(IndexingApplication.class);
    private static String job = "";
    private static ZonedDateTime modifiedTimestamp;
    @Autowired
    private IndexingBatchConfig batchConfig;

    public static void main(String[] args) {
        job = args.length > 0 ? args[0] : "";
        modifiedTimestamp = args.length > 1 ? ZonedDateTime.parse(args[1], DateTimeFormatter.ISO_DATE_TIME) : null;
        IndexingApplication.validateArgs();
        ConfigurableApplicationContext context = SpringApplication.run(IndexingApplication.class, (String[])args);
        System.exit(SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
    }

    private static void validateArgs() {
        if (StringUtils.hasLength((String)job) && !IndexingJobType.FULLTEXT_INDEXING.value().equalsIgnoreCase(job) && !IndexingJobType.METADATA_SYNC.value().equalsIgnoreCase(job)) {
            logger.error("Unsupported argument '{}'. Supported arguments are '{}' and '{}'", (Object)job, (Object)IndexingJobType.FULLTEXT_INDEXING.value(), (Object)IndexingJobType.METADATA_SYNC.value());
            System.exit(1);
        }
    }

    public void run(String ... args) throws Exception {
        if (IndexingJobType.FULLTEXT_INDEXING.value().equalsIgnoreCase(job) || !StringUtils.hasLength((String)job)) {
            this.batchConfig.indexFulltext(modifiedTimestamp);
        } else if (IndexingJobType.METADATA_SYNC.value().equalsIgnoreCase(job)) {
            this.batchConfig.syncMetadataJob();
        }
    }
}

