/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.solr;

import eu.europeana.fulltext.exception.SolrServiceException;
import eu.europeana.fulltext.indexing.IndexingConstants;
import eu.europeana.fulltext.indexing.config.IndexingAppSettings;
import eu.europeana.fulltext.indexing.solr.SolrUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MetadataSolrService {
    private static final Logger log = LogManager.getLogger(MetadataSolrService.class);
    private final SolrClient metadataSolr;
    private final int retryLimit;

    public MetadataSolrService(@Qualifier(value="metadataSolr") SolrClient metadataSolr, IndexingAppSettings settings) {
        this.metadataSolr = metadataSolr;
        this.retryLimit = settings.getBatchRetryLimit();
    }

    public SolrDocument getDocument(String europeanaId) throws SolrServiceException {
        int attempts = 1;
        SolrQuery query = new SolrQuery("europeana_id:\"" + europeanaId + "\"").addField("*");
        while (attempts <= this.retryLimit) {
            try {
                QueryResponse response = this.metadataSolr.query((SolrParams)query);
                if (log.isDebugEnabled()) {
                    log.debug("Performed Metadata query in {}ms:  query={}; attempt={}", (Object)response.getElapsedTime(), (Object)query, (Object)attempts);
                }
                if (response != null && !response.getResults().isEmpty()) {
                    return (SolrDocument)response.getResults().get(0);
                }
                break;
            }
            catch (IOException | SolrServerException e) {
                if (++attempts > this.retryLimit) {
                    throw new SolrServiceException(String.format("Error while searching Solr for lastUpdateTime after %s attempts. query=%s", attempts - 1, query.toString()), e);
                }
                try {
                    Thread.sleep(IndexingConstants.SLEEP_MS);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return new SolrDocument();
    }

    public Optional<Instant> getMostRecentValue(String timestampField) throws SolrServiceException {
        return SolrUtils.getMostRecentValue((SolrClient)this.metadataSolr, (String)timestampField);
    }
}

