/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.reader;

import dev.morphia.query.MorphiaCursor;
import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.repository.IndexingAnnoPageRepository;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class AnnoPageRecordIdReader
extends AbstractPaginatedDataItemReader<AnnoPageRecordId> {
    private static final Logger logger = LogManager.getLogger(AnnoPageRecordIdReader.class);
    private final IndexingAnnoPageRepository repository;
    private final Instant from;
    private MorphiaCursor<AnnoPageRecordId> cursor;

    public AnnoPageRecordIdReader(IndexingAnnoPageRepository repository, Instant from) {
        this.repository = repository;
        this.from = from;
    }

    @NotNull
    protected Iterator<AnnoPageRecordId> doPageRead() {
        if (this.cursor != null && this.cursor.hasNext()) {
            AnnoPageRecordId next = (AnnoPageRecordId)this.cursor.next();
            if (logger.isTraceEnabled()) {
                logger.trace("Retrieved {}", (Object)next);
            }
            return List.of(next.copy()).iterator();
        }
        return Collections.emptyIterator();
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setSaveState(false);
        this.setName(AnnoPageRecordIdReader.class.getName());
        if (this.cursor == null) {
            this.cursor = this.repository.getAnnoPageRecordIdByModificationTime(Optional.ofNullable(this.from));
            if (logger.isDebugEnabled()) {
                logger.debug("Created Mongo Cursor for retrieving AnnoPage recordIds");
            }
        }
    }

    protected void doClose() throws Exception {
        super.doClose();
        if (this.cursor != null) {
            this.cursor.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Closed Mongo cursor");
            }
        }
    }
}

