/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingAction;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import eu.europeana.fulltext.indexing.processor.ProcessorUtils;
import eu.europeana.fulltext.util.GeneralUtils;
import org.apache.solr.common.SolrDocument;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
public class MetadataSyncWrapperCreator
implements ItemProcessor<SolrDocument, IndexingWrapper> {
    public IndexingWrapper process(SolrDocument doc) throws Exception {
        String europeanaId = doc.getFieldValue("europeana_id").toString();
        return new IndexingWrapper(this.createAnnoPageRecordId(europeanaId), ProcessorUtils.toSolrInputDocument((SolrDocument)doc), new IndexingAction[]{IndexingAction.UPDATE_METADATA_FIELDS, IndexingAction.WRITE_DOCUMENT});
    }

    private AnnoPageRecordId createAnnoPageRecordId(String europeanaId) {
        String dsId = GeneralUtils.getDsId((String)europeanaId);
        String lcId = GeneralUtils.getLocalId((String)europeanaId);
        return new AnnoPageRecordId(dsId, lcId);
    }
}

