/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.entity.AnnoPage;
import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingAction;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import eu.europeana.fulltext.indexing.processor.BaseIndexingWrapperProcessor;
import eu.europeana.fulltext.indexing.repository.IndexingAnnoPageRepository;
import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.response.schema.SchemaRepresentation;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.stereotype.Component;

@Component
public class FulltextIndexingProcessor
extends BaseIndexingWrapperProcessor {
    private final FulltextSolrService fulltextSolr;
    private final IndexingAnnoPageRepository repository;
    private static final Logger logger = LogManager.getLogger(FulltextIndexingProcessor.class);

    public FulltextIndexingProcessor(FulltextSolrService fulltextSolr, IndexingAnnoPageRepository repository) {
        super(IndexingAction.UPDATE_FULLTEXT_FIELDS);
        this.fulltextSolr = fulltextSolr;
        this.repository = repository;
    }

    public IndexingWrapper doProcessing(IndexingWrapper indexingWrapper) {
        AnnoPageRecordId recordId = indexingWrapper.getRecordId();
        String europeanaId = recordId.toEuropeanaId();
        HashMap<String, List> langFtContent = new HashMap<String, List>();
        SolrInputDocument doc = new SolrInputDocument(new String[]{"europeana_id", europeanaId});
        List annoPages = this.repository.getAnnoPagesWithProjection(recordId.getDsId(), recordId.getLcId());
        Map<Boolean, List<AnnoPage>> annoPageMap = annoPages.stream().collect(Collectors.groupingBy(AnnoPage::isActive));
        Date modified = Date.from(Instant.EPOCH);
        for (AnnoPage annoPage : annoPageMap.getOrDefault(Boolean.TRUE, Collections.emptyList())) {
            String fulltext = annoPage.getRes().getValue();
            String lang = annoPage.getLang();
            if (!this.isLangSupported(lang, this.fulltextSolr.getSchema())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Record {} - language not supported: {} . Indexing in fulltext.", (Object)europeanaId, (Object)lang);
                }
                lang = "";
            }
            String target = annoPage.getTgtId();
            Date apModified = annoPage.getModified();
            if (modified.before(apModified)) {
                modified = apModified;
            }
            String content = this.addFulltextPrefix(target, fulltext);
            List listContents = langFtContent.computeIfAbsent(lang, k -> new ArrayList());
            listContents.add(content);
        }
        for (AnnoPage annoPage : annoPageMap.getOrDefault(Boolean.FALSE, Collections.emptyList())) {
            String lang = annoPage.getLang();
            if (logger.isTraceEnabled() && !this.isLangSupported(lang, this.fulltextSolr.getSchema())) {
                logger.trace("Record {} - language not supported: {} . Indexing in fulltext.", (Object)europeanaId, (Object)lang);
            }
            if (langFtContent.containsKey(lang)) continue;
            langFtContent.put(lang, new ArrayList());
        }
        for (Map.Entry entry : langFtContent.entrySet()) {
            doc.addField("fulltext." + (String)entry.getKey(), Map.of("set", (List)entry.getValue()));
        }
        doc.addField("timestamp_update_fulltext", Map.of("set", modified));
        indexingWrapper.setSolrDocument(doc);
        return indexingWrapper;
    }

    private boolean isLangSupported(String language, SchemaRepresentation schema) {
        if (language == null || language.isEmpty()) {
            return false;
        }
        return schema.getFields().stream().map(p -> p.get("name")).collect(Collectors.toList()).contains("fulltext." + language);
    }

    private String addFulltextPrefix(String target, String fulltext) {
        return "{" + target + "} " + fulltext;
    }
}

