/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.indexing.model.IndexingAction;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import java.util.Set;
import org.springframework.batch.item.ItemProcessor;

public abstract class BaseIndexingWrapperProcessor
implements ItemProcessor<IndexingWrapper, IndexingWrapper> {
    private final IndexingAction processorAction;

    protected BaseIndexingWrapperProcessor(IndexingAction processorAction) {
        this.processorAction = processorAction;
    }

    protected boolean shouldProcess(Set<IndexingAction> indexingActions) {
        return indexingActions.contains(this.processorAction);
    }

    public IndexingWrapper process(IndexingWrapper indexingWrapper) throws Exception {
        if (this.shouldProcess(indexingWrapper.getActions())) {
            return this.doProcessing(indexingWrapper);
        }
        return indexingWrapper;
    }

    protected abstract IndexingWrapper doProcessing(IndexingWrapper var1) throws Exception;
}

