/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.config;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import eu.europeana.fulltext.entity.FulltextPackageMapper;
import eu.europeana.fulltext.indexing.config.IndexingAppSettings;
import eu.europeana.fulltext.util.MorphiaUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IndexingDataSourceConfig {
    private static final Logger LOG = LogManager.getLogger(IndexingDataSourceConfig.class);
    private final IndexingAppSettings settings;

    public IndexingDataSourceConfig(IndexingAppSettings settings) {
        this.settings = settings;
    }

    @Bean
    public Datastore fulltextDatastore() {
        LOG.info("Configuring fulltext database: {}", (Object)this.settings.getFulltextDatabase());
        Datastore datastore = Morphia.createDatastore((MongoClient)MongoClients.create((String)this.settings.getMongoConnectionUrl()), (String)this.settings.getFulltextDatabase(), (MapperOptions)MorphiaUtils.MAPPER_OPTIONS);
        if (this.settings.ensureFulltextIndices()) {
            datastore.getMapper().mapPackage(FulltextPackageMapper.class.getPackageName());
            datastore.ensureIndexes();
        }
        return datastore;
    }

    @Bean(value={"metadataSolr"})
    public CloudSolrClient metadataSolrClient() {
        LOG.info("Configuring metadata solr client: {}", (Object)this.settings.getMetadataSolrUrl());
        CloudSolrClient client = new CloudSolrClient.Builder(List.of(this.settings.getMetadataSolrUrl())).build();
        client.setDefaultCollection(this.settings.getMetadataCollection());
        return client;
    }

    @Bean(value={"fulltextSolr"})
    public SolrClient fulltextSolrClient() {
        if (StringUtils.isNotBlank((CharSequence)this.settings.getFulltextZkUrl())) {
            return this.initSolrCloudClient();
        }
        return this.initHttpSolrClient();
    }

    private SolrClient initHttpSolrClient() {
        String fulltextSolrUrl = this.settings.getFulltextSolrUrl();
        LOG.info("Configuring Fulltext solr client: {}", (Object)fulltextSolrUrl);
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
        return builder.withBaseSolrUrl(fulltextSolrUrl).build();
    }

    private SolrClient initSolrCloudClient() {
        LOG.info("Configuring indexing solr client with the zookeperurls: {} and collection: {}", (Object)this.settings.getFulltextZkUrl(), (Object)this.settings.getFulltextCollection());
        String[] solrZookeeperUrls = this.settings.getFulltextZkUrl().trim().split(",");
        CloudSolrClient client = new CloudSolrClient.Builder(Arrays.asList(solrZookeeperUrls), Optional.empty()).build();
        client.setDefaultCollection(this.settings.getFulltextCollection());
        return client;
    }
}

