/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:indexing.properties"}), @PropertySource(value={"classpath:indexing.user.properties"}, ignoreResourceNotFound=true)})
public class IndexingAppSettings {
    @Value(value="${mongo.connectionUrl}")
    private String mongoConnectionUrl;
    @Value(value="${mongo.fulltext.database}")
    private String fulltextDatabase;
    @Value(value="${solr.fulltext.url}")
    private String fulltextSolrUrl;
    @Value(value="${solr.fulltext.collection}")
    private String fulltextCollection;
    @Value(value="${solr.metadata.url}")
    private String metadataSolrUrl;
    @Value(value="${solr.metadata.collection}")
    private String metadataCollection;
    @Value(value="${solr.fulltext.zk.url:}")
    private String fulltextZkUrl;
    @Value(value="${batch.executor.corePool: 5}")
    private int batchCorePoolSize;
    @Value(value="${batch.executor.maxPool: 10}")
    private int batchMaxPoolSize;
    @Value(value="${batch.throttleLimit: 5}")
    private int batchThrottleLimit;
    @Value(value="${batch.executor.queueSize: 5}")
    private int batchQueueSize;
    @Value(value="${batch.pageSize: 100}")
    private int pageSize;
    @Value(value="${batch.metadataSync.pageSize: 5000}")
    private int metadataSolrSyncPageSize;
    @Value(value="${mongo.fulltext.ensureIndices: false}")
    private boolean ensureFulltextIndices;
    @Value(value="${batch.skipLimit: 500}")
    private int skipLimit;
    @Value(value="${batch.retryLimit: 3}")
    private int batchRetryLimit;
    @Value(value="${batch.fulltext.commitWithinMs: 30000}")
    private int commitWithinMs;
    @Value(value="${batch.progressLoggingInterval: 10000}")
    private long progressLoggingInterval;

    public String getMongoConnectionUrl() {
        return this.mongoConnectionUrl;
    }

    public String getFulltextDatabase() {
        return this.fulltextDatabase;
    }

    public String getFulltextSolrUrl() {
        return this.fulltextSolrUrl;
    }

    public String getFulltextCollection() {
        return this.fulltextCollection;
    }

    public String getMetadataSolrUrl() {
        return this.metadataSolrUrl;
    }

    public String getMetadataCollection() {
        return this.metadataCollection;
    }

    public String getFulltextZkUrl() {
        return this.fulltextZkUrl;
    }

    public int getBatchCorePoolSize() {
        return this.batchCorePoolSize;
    }

    public int getBatchMaxPoolSize() {
        return this.batchMaxPoolSize;
    }

    public int getBatchQueueSize() {
        return this.batchQueueSize;
    }

    public int getBatchThrottleLimit() {
        return this.batchThrottleLimit;
    }

    public int getBatchPageSize() {
        return this.pageSize;
    }

    public int getMetadataSolrSyncPageSize() {
        return this.metadataSolrSyncPageSize;
    }

    public boolean ensureFulltextIndices() {
        return this.ensureFulltextIndices;
    }

    public int getSkipLimit() {
        return this.skipLimit;
    }

    public int getCommitWithinMs() {
        return this.commitWithinMs;
    }

    public int getBatchRetryLimit() {
        return this.batchRetryLimit;
    }

    public long getProgressLoggingInterval() {
        return this.progressLoggingInterval;
    }
}

