/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing;

import eu.europeana.fulltext.indexing.config.IndexingAppSettings;
import eu.europeana.fulltext.indexing.listener.FulltextIndexingListener;
import eu.europeana.fulltext.indexing.listener.MetadataSyncProcessListener;
import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import eu.europeana.fulltext.indexing.processor.FulltextIndexingProcessor;
import eu.europeana.fulltext.indexing.processor.FulltextIndexingWrapperCreator;
import eu.europeana.fulltext.indexing.processor.IndexingMetadataSyncProcessor;
import eu.europeana.fulltext.indexing.processor.MetadataSyncWrapperCreator;
import eu.europeana.fulltext.indexing.reader.AnnoPageRecordIdReader;
import eu.europeana.fulltext.indexing.reader.FulltextSolrDocumentReader;
import eu.europeana.fulltext.indexing.repository.IndexingAnnoPageRepository;
import eu.europeana.fulltext.indexing.solr.FulltextSolrService;
import eu.europeana.fulltext.indexing.writer.FulltextSolrDeletionWriter;
import eu.europeana.fulltext.indexing.writer.FulltextSolrInsertionWriter;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.item.support.SynchronizedItemStreamReader;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
@EnableBatchProcessing
public class IndexingBatchConfig {
    private static final Logger logger = LogManager.getLogger(IndexingBatchConfig.class);
    private final JobLauncher jobLauncher;
    private final JobParameters jobParams = new JobParametersBuilder().addDate("startTime", new Date()).toJobParameters();
    private final JobBuilderFactory jobs;
    private final StepBuilderFactory steps;
    private final TaskExecutor indexingTaskExecutor;
    private final IndexingAppSettings appSettings;
    private final FulltextSolrService fulltextSolr;
    private final FulltextIndexingWrapperCreator fulltextIndexingWrapperCreator;
    private final MetadataSyncWrapperCreator metadataSyncWrapperCreator;
    private final FulltextIndexingProcessor fulltextIndexingProcessor;
    private final IndexingMetadataSyncProcessor metadataSyncProcessor;
    private final FulltextIndexingListener fulltextIndexingListener;
    private final MetadataSyncProcessListener metadataSyncListener;
    private final FulltextSolrInsertionWriter fulltextSolrInsertionWriter;
    private final FulltextSolrDeletionWriter fulltextSolrDeletionWriter;
    private final IndexingAnnoPageRepository repository;

    public IndexingBatchConfig(JobBuilderFactory jobs, StepBuilderFactory steps, @Qualifier(value="batchThreadExecutor") TaskExecutor indexingTaskExecutor, IndexingAppSettings appSettings, FulltextSolrService fulltextSolr, FulltextIndexingWrapperCreator fulltextIndexingWrapperCreator, MetadataSyncWrapperCreator metadataSyncWrapperCreator, FulltextIndexingProcessor fulltextIndexingProcessor, IndexingMetadataSyncProcessor metadataSyncProcessor, FulltextIndexingListener fulltextIndexingListener, MetadataSyncProcessListener metadataSyncListener, FulltextSolrInsertionWriter fulltextSolrInsertionWriter, FulltextSolrDeletionWriter fulltextSolrDeletionWriter, IndexingAnnoPageRepository repository, JobLauncher jobLauncher) {
        this.jobs = jobs;
        this.steps = steps;
        this.indexingTaskExecutor = indexingTaskExecutor;
        this.appSettings = appSettings;
        this.fulltextSolr = fulltextSolr;
        this.fulltextIndexingWrapperCreator = fulltextIndexingWrapperCreator;
        this.metadataSyncWrapperCreator = metadataSyncWrapperCreator;
        this.fulltextIndexingProcessor = fulltextIndexingProcessor;
        this.metadataSyncProcessor = metadataSyncProcessor;
        this.fulltextIndexingListener = fulltextIndexingListener;
        this.metadataSyncListener = metadataSyncListener;
        this.fulltextSolrInsertionWriter = fulltextSolrInsertionWriter;
        this.fulltextSolrDeletionWriter = fulltextSolrDeletionWriter;
        this.repository = repository;
        this.jobLauncher = jobLauncher;
    }

    private ItemReader<AnnoPageRecordId> recordIdReader(Optional<Instant> from) {
        return this.threadSafeReader((ItemStreamReader)new AnnoPageRecordIdReader(this.repository, (Instant)from.orElse(null)));
    }

    private ItemReader<SolrDocument> fulltextSolrReader() {
        return this.threadSafeReader((ItemStreamReader)new FulltextSolrDocumentReader(this.fulltextSolr));
    }

    private <T> SynchronizedItemStreamReader<T> threadSafeReader(ItemStreamReader<T> reader) {
        SynchronizedItemStreamReader synchronizedItemStreamReader = new SynchronizedItemStreamReader();
        synchronizedItemStreamReader.setDelegate(reader);
        return synchronizedItemStreamReader;
    }

    private ItemWriter<IndexingWrapper> compositeWriter() {
        CompositeItemWriter writer = new CompositeItemWriter();
        writer.setDelegates(List.of(this.fulltextSolrInsertionWriter, this.fulltextSolrDeletionWriter));
        return writer;
    }

    private ItemProcessor<AnnoPageRecordId, IndexingWrapper> compositeFulltextIndexingProcessor() {
        CompositeItemProcessor processor = new CompositeItemProcessor();
        processor.setDelegates(List.of(this.fulltextIndexingWrapperCreator, this.fulltextIndexingProcessor, this.metadataSyncProcessor));
        return processor;
    }

    private ItemProcessor<SolrDocument, IndexingWrapper> compositeMetadataSyncProcessor() {
        CompositeItemProcessor processor = new CompositeItemProcessor();
        processor.setDelegates(List.of(this.metadataSyncWrapperCreator, this.metadataSyncProcessor));
        return processor;
    }

    private Step syncFulltextStep(Optional<Instant> from) {
        return this.steps.get("syncFulltextStep").chunk(this.appSettings.getBatchPageSize()).reader(this.recordIdReader(from)).listener((ItemReadListener)this.fulltextIndexingListener).processor(this.compositeFulltextIndexingProcessor()).listener((ItemProcessListener)this.fulltextIndexingListener).writer(this.compositeWriter()).listener((ItemWriteListener)this.fulltextIndexingListener).faultTolerant().skip(Exception.class).skipLimit(this.appSettings.getSkipLimit()).taskExecutor(this.indexingTaskExecutor).throttleLimit(this.appSettings.getBatchThrottleLimit()).build();
    }

    private Step syncMetadataStep() {
        return this.steps.get("syncMetadataStep").chunk(this.appSettings.getBatchPageSize()).reader(this.fulltextSolrReader()).processor(this.compositeMetadataSyncProcessor()).listener((Object)this.metadataSyncListener).writer(this.compositeWriter()).listener((ItemWriteListener)this.fulltextIndexingListener).faultTolerant().skip(Exception.class).skipLimit(this.appSettings.getSkipLimit()).taskExecutor(this.indexingTaskExecutor).throttleLimit(this.appSettings.getBatchThrottleLimit()).build();
    }

    public void indexFulltext(ZonedDateTime modifiedTimestamp) throws Exception {
        Optional from = modifiedTimestamp != null ? Optional.of(modifiedTimestamp.toInstant()) : Optional.empty();
        logger.info("Indexing Fulltext records modified after {}", from);
        this.jobLauncher.run(this.jobs.get("fulltextIndexJob").start(this.syncFulltextStep(from)).build(), this.jobParams);
    }

    public void syncMetadataJob() throws Exception {
        this.jobLauncher.run(this.jobs.get("syncMetadataJob").start(this.syncMetadataStep()).build(), this.jobParams);
    }
}

