/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;

public class ProcessorUtils {
    private ProcessorUtils() {
    }

    public static SolrInputDocument toSolrInputDocument(SolrDocument d) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (String name : d.getFieldNames()) {
            doc.addField(name, d.getFieldValue(name));
        }
        return doc;
    }

    public static void mergeDocs(SolrDocument metadataDoc, SolrInputDocument destinationDoc, String europeanaId) {
        destinationDoc.setField("europeana_id", (Object)europeanaId);
        for (String field : metadataDoc.getFieldNames()) {
            if (field.equals("proxy_dcterms_issued")) {
                Collection listIssuedDates = metadataDoc.getFieldValues("proxy_dcterms_issued");
                ArrayList<String> isoDates = new ArrayList<String>();
                for (Object d : listIssuedDates) {
                    try {
                        LocalDate localDate = LocalDate.parse(d.toString());
                        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.of("Z"));
                        isoDates.add(zonedDateTime.format(DateTimeFormatter.ISO_INSTANT));
                    }
                    catch (DateTimeException dateTimeException) {}
                }
                if (!isoDates.isEmpty()) {
                    destinationDoc.addField("issued", Map.of("set", isoDates));
                }
                destinationDoc.addField(field, Map.of("set", metadataDoc.getFieldValue(field)));
                continue;
            }
            if (field.equals("is_fulltext")) {
                destinationDoc.addField(field, Map.of("set", true));
                continue;
            }
            if (field.equals("timestamp_update")) {
                destinationDoc.setField(field, metadataDoc.getFieldValue("timestamp_update"));
                continue;
            }
            if (field.equals("europeana_id") || field.equals("timestamp") || field.equals("_version_")) continue;
            destinationDoc.addField(field, Map.of("set", metadataDoc.getFieldValue(field)));
        }
    }
}

