/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.processor;

import eu.europeana.fulltext.indexing.model.IndexingAction;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import eu.europeana.fulltext.indexing.processor.BaseIndexingWrapperProcessor;
import eu.europeana.fulltext.indexing.processor.ProcessorUtils;
import eu.europeana.fulltext.indexing.solr.MetadataSolrService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.stereotype.Component;

@Component
public class IndexingMetadataSyncProcessor
extends BaseIndexingWrapperProcessor {
    private static final Logger logger = LogManager.getLogger(IndexingMetadataSyncProcessor.class);
    private final MetadataSolrService metadataSolr;

    public IndexingMetadataSyncProcessor(MetadataSolrService metadataSolr) {
        super(IndexingAction.UPDATE_METADATA_FIELDS);
        this.metadataSolr = metadataSolr;
    }

    protected IndexingWrapper doProcessing(IndexingWrapper indexingWrapper) throws Exception {
        String europeanaId = indexingWrapper.getRecordId().toEuropeanaId();
        SolrDocument metadataSolrDocument = this.metadataSolr.getDocument(europeanaId);
        if (metadataSolrDocument == null || metadataSolrDocument.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} does not exist in metadata collection. Will delete document in fulltext solr", (Object)europeanaId);
            }
            indexingWrapper.markForDeletion();
            return indexingWrapper;
        }
        Date fulltextSolrTimestamp = indexingWrapper.getSolrDocument().containsKey((Object)"timestamp_update") ? (Date)indexingWrapper.getSolrDocument().getFieldValue("timestamp_update") : null;
        Date metadataSolrTimestamp = (Date)metadataSolrDocument.getFieldValue("timestamp_update");
        if (fulltextSolrTimestamp != null && !metadataSolrTimestamp.after(fulltextSolrTimestamp)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} timestamp_update in metadata collection not after fulltext collection value; document not updated", (Object)europeanaId);
            }
            return null;
        }
        SolrInputDocument fulltextDoc = indexingWrapper.getSolrDocument();
        ProcessorUtils.mergeDocs((SolrDocument)metadataSolrDocument, (SolrInputDocument)fulltextDoc, (String)europeanaId);
        return indexingWrapper;
    }
}

