/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.model;

import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.common.SolrInputDocument;

public class IndexingWrapper {
    private final AnnoPageRecordId recordId;
    private final Set<IndexingAction> actions = new HashSet();
    private SolrInputDocument solrDocument;

    public IndexingWrapper(AnnoPageRecordId recordId, IndexingAction ... actions) {
        this.recordId = recordId;
        this.actions.addAll(Set.of(actions));
    }

    public IndexingWrapper(AnnoPageRecordId recordId, SolrInputDocument document, IndexingAction ... actions) {
        this(recordId, actions);
        this.setSolrDocument(document);
    }

    public Set<IndexingAction> getActions() {
        return this.actions;
    }

    public AnnoPageRecordId getRecordId() {
        return this.recordId;
    }

    public SolrInputDocument getSolrDocument() {
        return this.solrDocument;
    }

    public void setSolrDocument(SolrInputDocument solrDocument) {
        this.solrDocument = solrDocument;
    }

    public void markForDeletion() {
        this.actions.remove(IndexingAction.WRITE_DOCUMENT);
        this.actions.add(IndexingAction.DELETE_DOCUMENT);
    }

    public String toString() {
        return "{action=" + this.actions + ", recordId=" + this.recordId + ", solrDocument=" + this.solrDocument + "}";
    }
}

