/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.indexing.listener;

import eu.europeana.fulltext.indexing.IndexingConstants;
import eu.europeana.fulltext.indexing.model.AnnoPageRecordId;
import eu.europeana.fulltext.indexing.model.IndexingWrapper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.listener.ItemListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class FulltextIndexingListener
extends ItemListenerSupport<AnnoPageRecordId, IndexingWrapper> {
    private static final Logger logger = LogManager.getLogger(FulltextIndexingListener.class);

    public void onReadError(Exception ex) {
        logger.warn("Error during read", (Throwable)ex);
    }

    public void onProcessError(AnnoPageRecordId item, Exception e) {
        logger.warn("Error during processing. {}", (Object)item, (Object)e);
    }

    public void onWriteError(Exception ex, List<? extends IndexingWrapper> list) {
        logger.warn("Error during write. ObjectIds={}", (Object)IndexingConstants.getRecordId(list), (Object)ex);
    }
}

