/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.web;

import eu.europeana.iiif.model.v3.ManifestV3;
import eu.europeana.iiif.service.ManifestService;
import eu.europeana.iiif.service.exception.IIIFException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ManifestController {
    private ManifestService manifestService;
    private Pattern acceptProfilePattern = Pattern.compile("profile=\"(.*?)\"");

    public ManifestController(ManifestService manifestService) {
        this.manifestService = manifestService;
    }

    @RequestMapping(value={"/presentation/{collectionId}/{recordId}/manifest"}, method={RequestMethod.GET}, produces={"application/ld+json;profile=\"http://iiif.io/api/presentation/2/context.json\"", "application/ld+json;profile=\"http://iiif.io/api/presentation/3/context.json\"", "application/ld+json", "application/json"})
    public String manifest(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="format", required=false) String version, @RequestParam(value="recordApi", required=false) URL recordApi, HttpServletRequest request, HttpServletResponse response) throws IIIFException {
        ManifestV3 manifest;
        String id = "/" + collectionId + "/" + recordId;
        String json = this.manifestService.getRecordJson(id, wskey, recordApi);
        String iiifVersion = version;
        if (iiifVersion == null) {
            iiifVersion = this.versionFromAcceptHeader(request);
        }
        if ("3".equalsIgnoreCase(iiifVersion)) {
            manifest = this.manifestService.generateManifestV3(json);
            response.setContentType("application/ld+json;profile=\"http://iiif.io/api/presentation/3/context.json\";charset=UTF-8");
        } else {
            manifest = this.manifestService.generateManifestV2(json);
            response.setContentType("application/ld+json;profile=\"http://iiif.io/api/presentation/2/context.json\";charset=UTF-8");
        }
        return this.manifestService.serializeManifest((Object)manifest);
    }

    private String versionFromAcceptHeader(HttpServletRequest request) {
        Matcher m;
        String result = "2";
        String accept = request.getHeader("Accept");
        if (StringUtils.isNotEmpty((String)accept) && (m = this.acceptProfilePattern.matcher(accept)).find()) {
            String profiles = m.group(1);
            result = profiles.toLowerCase(Locale.getDefault()).contains("http://iiif.io/api/presentation/3/context.json") ? "3" : "2";
        }
        return result;
    }
}

