/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.service;

import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

@Configuration
@Component
@PropertySources(value={@PropertySource(value={"classpath:iiif.properties"}), @PropertySource(value={"classpath:iiif.user.properties"}, ignoreResourceNotFound=true)})
public class ManifestSettings {
    private static final Logger LOG = LogManager.getLogger(ManifestSettings.class);
    @Value(value="${record-api.baseurl}")
    private String recordApiBaseUrl;
    @Value(value="${record-api.path}")
    private String recordApiPath;
    @Value(value="${suppress-parse-exception}")
    private Boolean suppressParseException = false;
    @Value(value="${canvas.height}")
    private Integer canvasHeight;
    @Value(value="${canvas.width}")
    private Integer canvasWidth;

    public String getRecordApiBaseUrl() {
        return this.recordApiBaseUrl;
    }

    public String getRecordApiApiPath() {
        return this.recordApiPath;
    }

    public Boolean getSuppressParseException() {
        return this.suppressParseException;
    }

    public Integer getCanvasHeight() {
        return this.canvasHeight;
    }

    public Integer getCanvasWidth() {
        return this.canvasWidth;
    }

    @PostConstruct
    private void logImportantSettings() {
        LOG.info("Manifest settings:");
        LOG.info("  Record API Url = {}{} ", (Object)this.getRecordApiBaseUrl(), (Object)this.getRecordApiApiPath());
        LOG.info("  Suppress parse exceptions = {}", (Object)this.getSuppressParseException());
    }
}

