/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import eu.europeana.iiif.model.v2.ManifestV2;
import eu.europeana.iiif.model.v3.ManifestV3;
import eu.europeana.iiif.service.EdmManifestMapping;
import eu.europeana.iiif.service.ManifestSettings;
import eu.europeana.iiif.service.exception.IIIFException;
import eu.europeana.iiif.service.exception.InvalidApiKeyException;
import eu.europeana.iiif.service.exception.RecordNotFoundException;
import eu.europeana.iiif.service.exception.RecordParseException;
import eu.europeana.iiif.service.exception.RecordRetrieveException;
import ioinformarics.oss.jackson.module.jsonld.JsonldModule;
import java.io.IOException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ManifestService {
    private static final Logger LOG = LogManager.getLogger(ManifestService.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private ManifestSettings settings = new ManifestSettings();
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    public ManifestService(ManifestSettings settings) {
        this.settings = settings;
        Configuration.setDefaults((Configuration.Defaults)new /* Unavailable Anonymous Inner Class!! */);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.registerModule((Module)new JsonldModule());
    }

    protected ObjectMapper getJsonMapper() {
        return mapper;
    }

    public String getRecordJson(String recordId, String wsKey) throws IIIFException {
        return this.getRecordJson(recordId, wsKey, null);
    }

    @HystrixCommand(ignoreExceptions={InvalidApiKeyException.class, RecordNotFoundException.class}, commandProperties={@HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="20000"), @HystrixProperty(name="fallback.enabled", value="false")})
    public String getRecordJson(String recordId, String wsKey, URL recordApiUrl) throws IIIFException {
        String result = null;
        StringBuilder url = recordApiUrl == null ? new StringBuilder(this.settings.getRecordApiBaseUrl()) : new StringBuilder(recordApiUrl.toString());
        url.append(this.settings.getRecordApiApiPath());
        url.append(recordId);
        url.append(".json?wskey=");
        url.append(wsKey);
        try {
            String recordUrl = url.toString();
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(recordUrl));){
                int responseCode = response.getStatusLine().getStatusCode();
                LOG.debug("Record request: {}, status code = {}", (Object)recordId, (Object)responseCode);
                if (responseCode == 401) {
                    throw new InvalidApiKeyException("API key is not valid");
                }
                if (responseCode == 404) {
                    throw new RecordNotFoundException("Record with id '" + recordId + "' not found");
                }
                if (responseCode != 200) {
                    throw new RecordRetrieveException("Error retrieving record: " + response.getStatusLine().getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity);
                    LOG.debug("Record request: {}, response = {}", (Object)recordId, (Object)result);
                    EntityUtils.consume((HttpEntity)entity);
                } else {
                    LOG.warn("Request entity = null");
                }
            }
        }
        catch (IOException e) {
            throw new RecordRetrieveException("Error retrieving record", (Throwable)e);
        }
        return result;
    }

    public ManifestV2 generateManifestV2(String json) {
        long start = System.currentTimeMillis();
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(json);
        ManifestV2 result = EdmManifestMapping.getManifestV2((ManifestSettings)this.settings, (Object)document);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public ManifestV3 generateManifestV3(String json) {
        long start = System.currentTimeMillis();
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(json);
        ManifestV3 result = EdmManifestMapping.getManifestV3((ManifestSettings)this.settings, (Object)document);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated in {} ms ", (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    public String serializeManifest(Object m) throws RecordParseException {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(m);
        }
        catch (IOException e) {
            throw new RecordParseException("Error serializing data: " + e.getMessage(), (Throwable)e);
        }
    }

    public ManifestSettings getSettings() {
        return this.settings;
    }
}

