/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.service;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import eu.europeana.iiif.model.EdmDateUtils;
import eu.europeana.iiif.model.WebResource;
import eu.europeana.iiif.model.WebResourceSorter;
import eu.europeana.iiif.model.v2.Annotation;
import eu.europeana.iiif.model.v2.AnnotationBody;
import eu.europeana.iiif.model.v2.Canvas;
import eu.europeana.iiif.model.v2.DataSet;
import eu.europeana.iiif.model.v2.Image;
import eu.europeana.iiif.model.v2.LanguageObject;
import eu.europeana.iiif.model.v2.ManifestV2;
import eu.europeana.iiif.model.v2.MetaData;
import eu.europeana.iiif.model.v2.Sequence;
import eu.europeana.iiif.model.v2.Service;
import eu.europeana.iiif.model.v3.Collection;
import eu.europeana.iiif.model.v3.LanguageMap;
import eu.europeana.iiif.model.v3.ManifestV3;
import eu.europeana.iiif.service.ManifestService;
import eu.europeana.iiif.service.ManifestSettings;
import eu.europeana.iiif.service.exception.DataInconsistentException;
import eu.europeana.iiif.service.exception.RecordParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EdmManifestMapping {
    private static final Logger LOG = LogManager.getLogger(EdmManifestMapping.class);

    private EdmManifestMapping() {
    }

    public static ManifestV2 getManifestV2(ManifestSettings settings, Object jsonDoc) {
        String europeanaId = EdmManifestMapping.getEuropeanaId((Object)jsonDoc);
        ManifestV2 manifest = new ManifestV2(EdmManifestMapping.getManifestId((String)europeanaId));
        manifest.setWithin(EdmManifestMapping.getWithinV2((Object)jsonDoc));
        manifest.setLabel(EdmManifestMapping.getLabelsV2((Object)jsonDoc));
        manifest.setDescription(EdmManifestMapping.getDescriptionV2((Object)jsonDoc));
        manifest.setMetadata(EdmManifestMapping.getMetaDataV2((Object)jsonDoc));
        manifest.setThumbnail(EdmManifestMapping.getThumbnailImageV2((ManifestSettings)settings, (String)europeanaId, (Object)jsonDoc));
        manifest.setNavDate(EdmManifestMapping.getNavDate((String)europeanaId, (Object)jsonDoc));
        manifest.setAttribution(EdmManifestMapping.getAttributionV2((String)europeanaId, (Object)jsonDoc));
        manifest.setLicense(EdmManifestMapping.getLicense((String)europeanaId, (Object)jsonDoc));
        manifest.setSeeAlso(EdmManifestMapping.getDataSetsV2((String)europeanaId));
        manifest.setSequences(EdmManifestMapping.getSequencesV2((ManifestSettings)settings, (String)europeanaId, (Object)jsonDoc));
        return manifest;
    }

    public static ManifestV3 getManifestV3(ManifestSettings settings, Object jsonDoc) {
        String europeanaId = EdmManifestMapping.getEuropeanaId((Object)jsonDoc);
        ManifestV3 manifest = new ManifestV3(EdmManifestMapping.getManifestId((String)europeanaId));
        manifest.setWithin(EdmManifestMapping.getWithinV3((Object)jsonDoc));
        manifest.setLabel(EdmManifestMapping.getLabelsV3((Object)jsonDoc));
        manifest.setDescription(EdmManifestMapping.getDescriptionV3((Object)jsonDoc));
        manifest.setNavDate(EdmManifestMapping.getNavDate((String)europeanaId, (Object)jsonDoc));
        manifest.setSeeAlso(EdmManifestMapping.getDataSetsV3((String)europeanaId));
        return manifest;
    }

    public static String getEuropeanaId(Object jsonDoc) {
        return (String)JsonPath.parse((Object)jsonDoc).read("$.object.about", String.class, new Predicate[0]);
    }

    public static String getManifestId(String europeanaId) {
        return "https://iiif.europeana.eu/presentation{DATASET_ID}/{RECORD_ID}/manifest".replace("{DATASET_ID}/{RECORD_ID}", europeanaId);
    }

    public static String getSequenceId(String europeanaId, int order) {
        return "https://iiif.europeana.eu/presentation{DATASET_ID}/{RECORD_ID}/sequence/s".replace("{DATASET_ID}/{RECORD_ID}", europeanaId).concat(Integer.toString(order));
    }

    public static String getCanvasId(String europeanaId, int order) {
        return "https://iiif.europeana.eu/presentation{DATASET_ID}/{RECORD_ID}/canvas/p".replace("{DATASET_ID}/{RECORD_ID}", europeanaId).concat(Integer.toString(order));
    }

    public static String getAnnotationId(String europeanaId, int order) {
        return "https://iiif.europeana.eu/presentation{DATASET_ID}/{RECORD_ID}/annotation/p".replace("{DATASET_ID}/{RECORD_ID}", europeanaId).concat(Integer.toString(order));
    }

    public static String getDatasetId(String europeanaId, String postFix) {
        return "https://www.europeana.eu/api/v2/record" + europeanaId + postFix;
    }

    public static String getWithinV2(Object jsonDoc) {
        return null;
    }

    public static Collection[] getWithinV3(Object jsonDoc) {
        ArrayList<Collection> result = new ArrayList<Collection>();
        List collections = (List)JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dctermsIsPartOf.def[*]", List.class, new Predicate[0]);
        for (String collection : collections) {
            if (!collection.toLowerCase(Locale.getDefault()).startsWith("http://data.theeuropeanlibrary.org") && !collection.toLowerCase(Locale.getDefault()).startsWith("https://data.theeuropeanlibrary.org")) continue;
            result.add(new Collection(collection));
        }
        return result.toArray(new Collection[result.size()]);
    }

    public static LanguageMap getLabelsV3(Object jsonDoc) {
        LanguageMap[] maps = (LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcTitle", LanguageMap[].class, new Predicate[0]);
        if (maps == null || maps.length == 0) {
            maps = (LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcDescription", LanguageMap[].class, new Predicate[0]);
        }
        return EdmManifestMapping.mergeLanguageMaps((LanguageMap[])maps);
    }

    public static LanguageObject[] getLabelsV2(Object jsonDoc) {
        LanguageMap labelsV3 = EdmManifestMapping.getLabelsV3((Object)jsonDoc);
        if (labelsV3 == null) {
            return null;
        }
        return EdmManifestMapping.langMapsToObjects((LinkedHashMap)labelsV3);
    }

    private static LanguageObject[] langMapsToObjects(LinkedHashMap<String, String[]> map) {
        if (map == null) {
            return null;
        }
        ArrayList<LanguageObject> result = new ArrayList<LanguageObject>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] values;
            String language = entry.getKey();
            for (String value : values = entry.getValue()) {
                result.add(new LanguageObject(language, value));
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new LanguageObject[result.size()]);
    }

    private static LanguageMap mergeLanguageMaps(LanguageMap[] maps) {
        if (maps == null || maps.length == 0) {
            return null;
        }
        if (maps.length == 1) {
            return maps[0];
        }
        LanguageMap result = new LanguageMap();
        for (LanguageMap map : maps) {
            if (LOG.isDebugEnabled()) {
                for (String key : map.keySet()) {
                    if (!result.keySet().contains(key)) continue;
                    LOG.warn("Duplicate key found when merging language maps: key = {}", (Object)key);
                }
            }
            result.putAll((Map)map);
        }
        return result;
    }

    public static LanguageMap getDescriptionV3(Object jsonDoc) {
        if (((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcTitle", LanguageMap[].class, new Predicate[0])).length > 0) {
            return EdmManifestMapping.mergeLanguageMaps((LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcDescription", LanguageMap[].class, new Predicate[0])));
        }
        return null;
    }

    public static LanguageObject[] getDescriptionV2(Object jsonDoc) {
        LanguageMap descriptionsV3 = EdmManifestMapping.getDescriptionV3((Object)jsonDoc);
        if (descriptionsV3 == null) {
            return null;
        }
        return EdmManifestMapping.langMapsToObjects((LinkedHashMap)EdmManifestMapping.getDescriptionV3((Object)jsonDoc));
    }

    public static MetaData[] getMetaDataV2(Object jsonDoc) {
        LinkedHashMap data = new LinkedHashMap();
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcDate", LanguageMap[].class, new Predicate[0])), (String)"date");
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcFormat", LanguageMap[].class, new Predicate[0])), (String)"format");
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcRelation", LanguageMap[].class, new Predicate[0])), (String)"relation");
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcType", LanguageMap[].class, new Predicate[0])), (String)"type");
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcLanguage", LanguageMap[].class, new Predicate[0])), (String)"language");
        EdmManifestMapping.addMetaData(data, (LanguageMap[])((LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dcSource", LanguageMap[].class, new Predicate[0])), (String)"source");
        LinkedList<MetaData> result = new LinkedList<MetaData>();
        for (Map.Entry entry : data.entrySet()) {
            String label = (String)entry.getKey();
            List values = (List)entry.getValue();
            result.add(new MetaData(label, values.toArray(new LanguageObject[values.size()])));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new MetaData[result.size()]);
    }

    private static void addMetaData(Map<String, List<LanguageObject>> metaData, LanguageMap[] dataToAdd, String fieldName) {
        for (LanguageMap map : dataToAdd) {
            for (Map.Entry entry : map.entrySet()) {
                String[] values;
                String language = (String)entry.getKey();
                for (String value : values = (String[])entry.getValue()) {
                    List<Object> langObjects;
                    if (!metaData.keySet().contains(fieldName)) {
                        langObjects = new ArrayList();
                        metaData.put(fieldName, langObjects);
                    } else {
                        langObjects = metaData.get(fieldName);
                    }
                    langObjects.add(new LanguageObject(language, value));
                }
            }
        }
    }

    public static Image getThumbnailImageV2(ManifestSettings settings, String europeanaId, Object jsonDoc) {
        Object[] thumbnailIds = (String[])JsonPath.parse((Object)jsonDoc).read("$.object.europeanaAggregation[?(@.edmPreview)].edmPreview", String[].class, new Predicate[0]);
        String thumbnailId = (String)EdmManifestMapping.getFirstValueArray((String)"thumbnail ids", (String)europeanaId, (Object[])thumbnailIds);
        if (StringUtils.isEmpty((Object)thumbnailId)) {
            return null;
        }
        return new Image(thumbnailId, null, null);
    }

    public static String getNavDate(String europeanaId, Object jsonDoc) {
        LanguageMap[] proxiesLangDates;
        Date navDate = null;
        for (LanguageMap langDates : proxiesLangDates = (LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.proxies[*].dctermsIssued", LanguageMap[].class, new Predicate[0])) {
            Object[] dates;
            String date;
            Iterator iterator = langDates.values().iterator();
            while (iterator.hasNext() && (navDate = EdmDateUtils.dateStringToDate((String)(date = (String)EdmManifestMapping.getFirstValueArray((String)"navDate", (String)europeanaId, (Object[])(dates = (String[])iterator.next()))))) == null) {
            }
            if (navDate != null) break;
        }
        if (navDate == null) {
            return null;
        }
        return navDate.toInstant().toString();
    }

    public static String getAttributionV2(String europeanaId, Object jsonDoc) {
        Object[] attributions = (String[])JsonPath.parse((Object)jsonDoc).read("$.object.aggregations[*].webResources[*].textAttributionSnippet", String[].class, new Predicate[0]);
        String attribution = (String)EdmManifestMapping.getFirstValueArray(null, (String)europeanaId, (Object[])attributions);
        if (!StringUtils.isEmpty((Object)attribution)) {
            return attribution;
        }
        return null;
    }

    public static String getLicense(String europeanaId, Object jsonDoc) {
        Object[] licenseMaps = (LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.europeanaAggregation[?(@.edmRights)].edmRights", LanguageMap[].class, new Predicate[0]);
        LanguageMap licenseMap = (LanguageMap)EdmManifestMapping.getFirstValueArray((String)"licenseMap", (String)europeanaId, (Object[])licenseMaps);
        if (licenseMap == null || licenseMap.values().isEmpty()) {
            Object[] licenses = (LanguageMap[])JsonPath.parse((Object)jsonDoc).read("$.object.aggregations[*].edmRights", LanguageMap[].class, new Predicate[0]);
            licenseMap = (LanguageMap)EdmManifestMapping.getFirstValueArray((String)"license", (String)europeanaId, (Object[])licenses);
        }
        if (licenseMap != null && !licenseMap.values().isEmpty()) {
            return (String)EdmManifestMapping.getFirstValueArray((String)"license text", (String)europeanaId, (Object[])((Object[])licenseMap.values().iterator().next()));
        }
        return null;
    }

    public static DataSet[] getDataSetsV2(String europeanaId) {
        DataSet[] result = new DataSet[]{new DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".json-ld"), "application/ld+json"), new DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".json"), "application/json"), new DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".rdf"), "application/rdf+xml")};
        return result;
    }

    public static eu.europeana.iiif.model.v3.DataSet[] getDataSetsV3(String europeanaId) {
        eu.europeana.iiif.model.v3.DataSet[] result = new eu.europeana.iiif.model.v3.DataSet[]{new eu.europeana.iiif.model.v3.DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".json-ld"), "application/ld+json"), new eu.europeana.iiif.model.v3.DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".json"), "application/json"), new eu.europeana.iiif.model.v3.DataSet(EdmManifestMapping.getDatasetId((String)europeanaId, (String)".rdf"), "application/rdf+xml")};
        return result;
    }

    public static Sequence[] getSequencesV2(ManifestSettings settings, String europeanaId, Object jsonDoc) {
        WebResource[] sorted;
        WebResource[] webResources = (WebResource[])JsonPath.parse((Object)jsonDoc).read("$.object.aggregations[*].webResources[*]", WebResource[].class, new Predicate[0]);
        Map[] services = (Map[])JsonPath.parse((Object)jsonDoc).read("$.object[?(@.services)].services[*]", Map[].class, new Predicate[0]);
        try {
            sorted = WebResourceSorter.sort((WebResource[])webResources);
        }
        catch (DataInconsistentException e) {
            LOG.error("Error trying to sort webresources for {}. Cause: {}", (Object)europeanaId, (Object)e.getMessage());
            sorted = webResources;
        }
        int order = 1;
        LinkedList<Canvas> canvases = new LinkedList<Canvas>();
        for (WebResource webResource : sorted) {
            canvases.add(EdmManifestMapping.getCanvas((ManifestSettings)settings, (String)europeanaId, (int)order, (Map)webResource, (Map[])services));
            ++order;
        }
        if (!canvases.isEmpty()) {
            Sequence[] result = new Sequence[]{new Sequence(EdmManifestMapping.getSequenceId((String)europeanaId, (int)1))};
            result[0].setStartCanvas(EdmManifestMapping.getCanvasId((String)europeanaId, (int)1));
            result[0].setCanvases(canvases.toArray(new Canvas[canvases.size()]));
            return result;
        }
        return null;
    }

    private static Canvas getCanvas(ManifestSettings settings, String europeanaId, int order, Map<String, Object> webResource, Map<String, Object>[] services) {
        List serviceIds;
        LinkedHashMap license;
        Canvas c = new Canvas(settings, EdmManifestMapping.getCanvasId((String)europeanaId, (int)order));
        c.setLabel("p. " + order);
        String attributionText = (String)webResource.get("textAttributionSnippet");
        if (!StringUtils.isEmpty((Object)attributionText)) {
            c.setAttribution(attributionText);
        }
        if ((license = (LinkedHashMap)webResource.get("webResourceEdmRights")) != null && !license.values().isEmpty()) {
            c.setLicense((String)((ArrayList)license.values().iterator().next()).get(0));
        }
        c.setImages(new Annotation[1]);
        c.getImages()[0] = new Annotation(EdmManifestMapping.getAnnotationId((String)europeanaId, (int)order));
        c.getImages()[0].setOn(c.getId());
        AnnotationBody body = new AnnotationBody((String)webResource.get("about"));
        String ebuCoreMimeType = (String)webResource.get("ebuCoreHasMimeType");
        if (!StringUtils.isEmpty((Object)ebuCoreMimeType)) {
            body.setFormat(ebuCoreMimeType);
        }
        if ((serviceIds = (List)webResource.get("svcsHasService")) != null && !serviceIds.isEmpty()) {
            String serviceId = (String)EdmManifestMapping.getFirstValueArray((String)"service", (String)europeanaId, (Object[])serviceIds.toArray());
            Service service = new Service(serviceId);
            service.setProfile(EdmManifestMapping.lookupServiceDoapImplements((Map[])services, (String)serviceId, (String)europeanaId));
            body.setService(service);
        }
        c.getImages()[0].setResource(body);
        return c;
    }

    private static String lookupServiceDoapImplements(Map<String, Object>[] services, String serviceId, String europeanaId) {
        String result = null;
        for (Map<String, Object> s : services) {
            String sId = (String)s.get("about");
            if (sId == null || !sId.equalsIgnoreCase(serviceId)) continue;
            Object doapImplements = s.get("doapImplements");
            if (doapImplements == null) {
                LOG.warn("Record {} has service {} with no doapImplements field", (Object)europeanaId, (Object)serviceId);
                break;
            }
            if (doapImplements instanceof List) {
                result = (String)((List)doapImplements).get(0);
                break;
            }
            result = (String)doapImplements;
            break;
        }
        if (result == null) {
            LOG.warn("Record {} defined service {} in webresource, but no such service is defined (with a doapImplements field)", (Object)europeanaId, (Object)serviceId);
        }
        return result;
    }

    private static Object getFirstValueArray(String fieldName, String europeanaId, Object[] values) {
        if (values.length >= 1) {
            if (!StringUtils.isEmpty((Object)fieldName) && values.length > 1) {
                LOG.warn("Multiple {} values found for record {}, returning first", (Object)fieldName, (Object)europeanaId);
            }
            return values[0];
        }
        return null;
    }

    public static void main(String[] args) {
        ManifestService s = new ManifestService(new ManifestSettings());
        String json = "";
        try {
            ManifestV2 m2 = s.generateManifestV2(json);
            LOG.debug("jsonld V2 = \n{}", (Object)s.serializeManifest((Object)m2));
            ManifestV3 m3 = s.generateManifestV3(json);
            LOG.debug("jsonld V3 = \n{}", (Object)s.serializeManifest((Object)m3));
        }
        catch (RecordParseException e) {
            LOG.error("Error generating manifest", (Throwable)e);
        }
    }
}

