/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.model.v3;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class LanguageMap
extends LinkedHashMap<String, String[]>
implements Serializable {
    private static final long serialVersionUID = -7678917507346373456L;
    private static final String NO_LANGUAGE_KEY = "@none";

    public LanguageMap() {
    }

    public LanguageMap(String language, String[] value) {
        if (language == null || language.isEmpty() || "def".equalsIgnoreCase(language)) {
            this.put(NO_LANGUAGE_KEY, value);
        } else {
            this.put(language, value);
        }
    }

    public LanguageMap(String language, String value) {
        String[] values = new String[]{value};
        if (language == null || language.isEmpty() || "def".equalsIgnoreCase(language)) {
            this.put(NO_LANGUAGE_KEY, values);
        } else {
            this.put(language, values);
        }
    }

    public LanguageMap(String[] values) {
        this.put(NO_LANGUAGE_KEY, values);
    }

    public LanguageMap(String value) {
        String[] values = new String[]{value};
        this.put(NO_LANGUAGE_KEY, values);
    }

    @Override
    public final String[] put(String key, String[] value) {
        return super.put(key, value);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        for (Map.Entry entry : this.entrySet()) {
            if (s.length() > 1) {
                s.append(", ");
            }
            String language = (String)entry.getKey();
            Object[] values = (String[])entry.getValue();
            s.append('{').append(language).append('=').append(Arrays.toString(values)).append('}');
        }
        s.append(')');
        return s.toString();
    }
}

