/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.iiif.model;

import eu.europeana.iiif.model.WebResource;
import eu.europeana.iiif.service.exception.DataInconsistentException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebResourceSorter {
    private static final Logger LOG = LogManager.getLogger(WebResourceSorter.class);

    private WebResourceSorter() {
    }

    public static WebResource[] sort(WebResource[] webResources) throws DataInconsistentException {
        LOG.debug("WebResources = ", (Object[])webResources);
        HashMap<String, WebResource> idsWebResources = new HashMap<String, WebResource>();
        HashMap<String, String> idsNextInSequence = new HashMap<String, String>();
        for (WebResource wr : webResources) {
            String wrId = wr.getId();
            if (idsWebResources.put(wrId, wr) != null) {
                throw new DataInconsistentException("Duplicate webresource id found " + wrId);
            }
            String nextInSequence = wr.getNextInSequence();
            idsNextInSequence.put(wrId, nextInSequence);
            LOG.debug("    {} -> {} ", (Object)wrId, (Object)nextInSequence);
        }
        Set startNodes = WebResourceSorter.getSequenceStartItems(idsNextInSequence);
        LOG.debug("  StartNodes = {}", (Object)startNodes);
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        for (String startNodeId : startNodes) {
            ArrayList sequence = WebResourceSorter.getSequence((String)startNodeId, idsWebResources, idsNextInSequence);
            LOG.debug("  Sequence = {}", (Object)sequence);
            result.addAll(sequence);
        }
        for (Map.Entry idWebResource : idsWebResources.entrySet()) {
            WebResource isolated = (WebResource)idWebResource.getValue();
            if (isolated.hasNextInSequence()) {
                throw new DataInconsistentException("Expected webresource " + isolated.getId() + " to not have a nextInSequence value");
            }
            result.add(isolated);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESULT = {}", result);
        }
        return result.toArray(new WebResource[result.size()]);
    }

    private static Set<String> getSequenceStartItems(Map<String, String> idsSequences) throws DataInconsistentException {
        HashSet<String> result = new HashSet<String>();
        for (String id : idsSequences.keySet()) {
            if (!WebResourceSorter.isStartOfSequence((String)id, idsSequences)) continue;
            result.add(id);
        }
        return result;
    }

    private static boolean isStartOfSequence(String webResourceId, Map<String, String> idsSequences) throws DataInconsistentException {
        String nextInSequenceId = idsSequences.get(webResourceId);
        if (StringUtils.isNotEmpty((String)nextInSequenceId)) {
            if (nextInSequenceId != null && !idsSequences.keySet().contains(nextInSequenceId)) {
                throw new DataInconsistentException("Inconsistent data: webresource " + webResourceId + " hasNextInSequence " + nextInSequenceId + " but that webresource cannot be found!");
            }
            return !idsSequences.values().contains(webResourceId);
        }
        return false;
    }

    private static ArrayList<WebResource> getSequence(String startNodeId, Map<String, WebResource> idsWebResources, Map<String, String> idsNextInSequence) throws DataInconsistentException {
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        String nodeId = startNodeId;
        do {
            WebResource wr;
            if ((wr = idsWebResources.remove(nodeId)) == null) {
                throw new DataInconsistentException("Unable to find webresource " + startNodeId + ". Most likely it's part of another sequence");
            }
            result.add(0, wr);
        } while ((nodeId = idsNextInSequence.remove(nodeId)) != null);
        return result;
    }
}

